/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.Collection;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;

public class SupressDuplicateRcptHandler
implements RcptHook {
    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        Collection rcptList = (Collection)session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction);
        if (rcptList != null && rcptList.contains(rcpt)) {
            StringBuilder responseBuffer = new StringBuilder();
            responseBuffer.append(DSNStatus.getStatus(2, "1.5")).append(" Recipient <").append(rcpt.toString()).append("> OK");
            session.getLogger().debug("Duplicate recipient not add to recipient list: " + rcpt.toString());
            return new HookResult(1, "250", responseBuffer.toString());
        }
        return HookResult.declined();
    }
}

