/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;

public class SpamTrapHandler
implements RcptHook {
    private final Map<String, Long> blockedIps = new HashMap<String, Long>();
    private Collection<String> spamTrapRecips = new ArrayList<String>();
    protected long blockTime = 4320000L;

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public void setSpamTrapRecipients(Collection<String> spamTrapRecips) {
        this.spamTrapRecips = spamTrapRecips;
    }

    public void setBlockTime(long blockTime) {
        this.blockTime = blockTime;
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        String address = session.getRemoteAddress().getAddress().getHostAddress();
        if (this.isBlocked(address, session)) {
            return HookResult.deny();
        }
        if (this.spamTrapRecips.contains(rcpt.toString().toLowerCase(Locale.US))) {
            this.addIp(address, session);
            return HookResult.deny();
        }
        return HookResult.declined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBlocked(String ip, SMTPSession session) {
        Long rawTime = this.blockedIps.get(ip);
        if (rawTime != null) {
            long blockTime = rawTime;
            if (blockTime > System.currentTimeMillis()) {
                session.getLogger().debug("BlockList contain Ip " + ip);
                return true;
            }
            session.getLogger().debug("Remove ip " + ip + " from blockList");
            Map<String, Long> map = this.blockedIps;
            synchronized (map) {
                this.blockedIps.remove(ip);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIp(String ip, SMTPSession session) {
        long bTime = System.currentTimeMillis() + this.blockTime;
        session.getLogger().debug("Add ip " + ip + " for " + bTime + " to blockList");
        Map<String, Long> map = this.blockedIps;
        synchronized (map) {
            this.blockedIps.put(ip, bTime);
        }
    }
}

