/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.UnknownHook;

public class MaxUnknownCmdHandler
implements UnknownHook {
    public static final int DEFAULT_MAX_UNKOWN = 5;
    private static final String UNKOWN_COMMAND_COUNT = "UNKNOWN_COMMAND_COUNT";
    private int maxUnknown = 5;

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public void setMaxUnknownCmdCount(int maxUnknown) {
        this.maxUnknown = maxUnknown;
    }

    @Override
    public HookResult doUnknown(SMTPSession session, String command) {
        Integer count = (Integer)session.getAttachment(UNKOWN_COMMAND_COUNT, ProtocolSession.State.Transaction);
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        session.setAttachment(UNKOWN_COMMAND_COUNT, count, ProtocolSession.State.Transaction);
        if (count > this.maxUnknown) {
            return new HookResult(18, "521", "Closing connection as too many unknown commands received");
        }
        return HookResult.declined();
    }
}

