/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;

public class MaxRcptHandler
implements RcptHook {
    private static final HookResult MAX_RCPT = new HookResult(2, "452", DSNStatus.getStatus(4, "5.3") + " Requested action not taken: max recipients reached");
    private int maxRcpt = 0;

    public void setMaxRcpt(int maxRcpt) {
        this.maxRcpt = maxRcpt;
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        if (session.getRcptCount() + 1 > this.maxRcpt) {
            session.getLogger().info("Maximum recipients of " + this.maxRcpt + " reached");
            return MAX_RCPT;
        }
        return HookResult.declined();
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }
}

