/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;

public class DNSRBLHandler
implements RcptHook {
    private String[] whitelist;
    private String[] blacklist;
    private boolean getDetail = false;
    private final String blocklistedDetail;
    public static final String RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME = "org.apache.james.smtpserver.rbl.blocklisted";
    public static final String RBL_DETAIL_MAIL_ATTRIBUTE_NAME = "org.apache.james.smtpserver.rbl.detail";

    public DNSRBLHandler() {
        this.blocklistedDetail = null;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public void setWhitelist(String[] whitelist) {
        if (whitelist != null) {
            this.whitelist = new String[whitelist.length];
            for (int i = 0; i < whitelist.length; ++i) {
                this.whitelist[i] = new String(whitelist[i]);
            }
        }
        this.whitelist = whitelist;
    }

    public void setBlacklist(String[] blacklist) {
        if (blacklist != null) {
            this.blacklist = new String[blacklist.length];
            for (int i = 0; i < blacklist.length; ++i) {
                this.blacklist[i] = new String(blacklist[i]);
            }
        }
    }

    public void setGetDetail(boolean getDetail) {
        this.getDetail = getDetail;
    }

    public void checkDNSRBL(SMTPSession session, String ipAddress) {
        if (session.isRelayingAllowed()) {
            session.getLogger().info("Ipaddress " + session.getRemoteAddress().getAddress() + " is allowed to relay. Don't check it");
            return;
        }
        if (this.whitelist != null || this.blacklist != null) {
            String[] rblList;
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(ipAddress, " .", false);
            while (st.hasMoreTokens()) {
                sb.insert(0, st.nextToken() + ".");
            }
            String reversedOctets = sb.toString();
            if (this.whitelist != null) {
                for (String rbl : rblList = this.whitelist) {
                    if (this.resolve(reversedOctets + rbl)) {
                        if (session.getLogger().isInfoEnabled()) {
                            session.getLogger().info("Connection from " + ipAddress + " whitelisted by " + rbl);
                        }
                        return;
                    }
                    if (!session.getLogger().isDebugEnabled()) continue;
                    session.getLogger().debug("IpAddress " + session.getRemoteAddress().getAddress() + " not listed on " + rbl);
                }
            }
            if (this.blacklist != null) {
                for (String rbl : rblList = this.blacklist) {
                    if (this.resolve(reversedOctets + rbl)) {
                        Collection<String> txt;
                        if (session.getLogger().isInfoEnabled()) {
                            session.getLogger().info("Connection from " + ipAddress + " restricted by " + rbl + " to SMTP AUTH/postmaster/abuse.");
                        }
                        if (this.getDetail && !(txt = this.resolveTXTRecords(reversedOctets + rbl)).isEmpty()) {
                            String blocklistedDetail = txt.iterator().next().toString();
                            session.setAttachment(RBL_DETAIL_MAIL_ATTRIBUTE_NAME, blocklistedDetail, ProtocolSession.State.Connection);
                        }
                        session.setAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, "true", ProtocolSession.State.Connection);
                        return;
                    }
                    if (!session.getLogger().isDebugEnabled()) continue;
                    session.getLogger().debug("unknown host exception thrown:" + rbl);
                }
            }
        }
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        String blocklisted;
        this.checkDNSRBL(session, session.getRemoteAddress().getAddress().getHostAddress());
        if (!session.isRelayingAllowed() && (blocklisted = (String)session.getAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection)) != null) {
            if (this.blocklistedDetail == null) {
                return new HookResult(2, DSNStatus.getStatus(5, "7.1") + " Rejected: unauthenticated e-mail from " + session.getRemoteAddress().getAddress() + " is restricted.  Contact the postmaster for details.");
            }
            return new HookResult(2, DSNStatus.getStatus(5, "7.1") + " " + this.blocklistedDetail);
        }
        return HookResult.declined();
    }

    protected boolean resolve(String ip) {
        try {
            InetAddress.getByName(ip);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    protected Collection<String> resolveTXTRecords(String ip) {
        return Collections.emptyList();
    }
}

