/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;

public abstract class AbstractValidRcptHandler
implements RcptHook {
    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        boolean reject = false;
        if (session.isRelayingAllowed()) {
            if (this.isLocalDomain(session, rcpt.getDomain()) && !this.isValidRecipient(session, rcpt)) {
                reject = true;
            }
        } else if (!this.isLocalDomain(session, rcpt.getDomain())) {
            session.getLogger().debug("Unknown domain " + rcpt.getDomain() + " so reject it");
        } else if (!this.isValidRecipient(session, rcpt)) {
            reject = true;
        }
        if (reject) {
            session.getLogger().info("Rejected message. Unknown user: " + rcpt.toString());
            return new HookResult(2, "550", DSNStatus.getStatus(5, "1.1") + " Unknown user: " + rcpt.toString());
        }
        return HookResult.declined();
    }

    protected abstract boolean isValidRecipient(SMTPSession var1, MailAddress var2);

    protected abstract boolean isLocalDomain(SMTPSession var1, String var2);
}

