/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.Iterator;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;

public abstract class AbstractGreylistHandler
implements RcptHook {
    private long tempBlockTime = 3600000L;
    private long autoWhiteListLifeTime = 3110400000L;
    private long unseenLifeTime = 14400000L;
    private static final HookResult TO_FAST = new HookResult(4, "451", DSNStatus.getStatus(4, "4.3") + " Temporary rejected: Reconnect to fast. Please try again later");
    private static final HookResult TEMPORARY_REJECT = new HookResult(4, "451", DSNStatus.getStatus(4, "4.3") + " Temporary rejected: Please try again later");

    public void setUnseenLifeTime(long unseenLifeTime) {
        this.unseenLifeTime = unseenLifeTime;
    }

    public void setAutoWhiteListLifeTime(long autoWhiteListLifeTime) {
        this.autoWhiteListLifeTime = autoWhiteListLifeTime;
    }

    public void setTempBlockTime(long tempBlockTime) {
        this.tempBlockTime = tempBlockTime;
    }

    private HookResult doGreyListCheck(SMTPSession session, MailAddress senderAddress, MailAddress recipAddress) {
        String recip = "";
        String sender = "";
        if (recipAddress != null) {
            recip = recipAddress.toString();
        }
        if (senderAddress != null) {
            sender = senderAddress.toString();
        }
        long time = System.currentTimeMillis();
        String ipAddress = session.getRemoteAddress().getAddress().getHostAddress();
        try {
            long createTimeStamp = 0L;
            int count = 0;
            Iterator<String> data = this.getGreyListData(ipAddress, sender, recip);
            if (data.hasNext()) {
                createTimeStamp = Long.parseLong(data.next());
                count = Integer.parseInt(data.next());
            }
            session.getLogger().debug("Triplet " + ipAddress + " | " + sender + " | " + recip + " -> TimeStamp: " + createTimeStamp);
            if (createTimeStamp > 0L) {
                long acceptTime = createTimeStamp + this.tempBlockTime;
                if (time < acceptTime && count == 0) {
                    return TO_FAST;
                }
            } else {
                session.getLogger().debug("New triplet " + ipAddress + " | " + sender + " | " + recip);
                this.insertTriplet(ipAddress, sender, recip, count, time);
                return TEMPORARY_REJECT;
            }
            session.getLogger().debug("Update triplet " + ipAddress + " | " + sender + " | " + recip + " -> timestamp: " + time);
            this.updateTriplet(ipAddress, sender, recip, count, time);
            if (Math.random() > 0.99) {
                session.getLogger().debug("Delete old entries");
                this.cleanupAutoWhiteListGreyList(time - this.autoWhiteListLifeTime);
                this.cleanupGreyList(time - this.unseenLifeTime);
            }
        }
        catch (Exception e) {
            session.getLogger().error("Error on greylist method: " + e.getMessage());
        }
        return HookResult.declined();
    }

    protected abstract Iterator<String> getGreyListData(String var1, String var2, String var3) throws Exception;

    protected abstract void insertTriplet(String var1, String var2, String var3, int var4, long var5) throws Exception;

    protected abstract void updateTriplet(String var1, String var2, String var3, int var4, long var5) throws Exception;

    protected abstract void cleanupAutoWhiteListGreyList(long var1) throws Exception;

    protected abstract void cleanupGreyList(long var1) throws Exception;

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        if (!session.isRelayingAllowed()) {
            return this.doGreyListCheck(session, sender, rcpt);
        }
        session.getLogger().info("IpAddress " + session.getRemoteAddress().getAddress().getHostAddress() + " is allowed to send. Skip greylisting.");
        return HookResult.declined();
    }
}

