/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.james.protocols.smtp.hook.MessageHook;

public class MailSizeEsmtpExtension
implements MailParametersHook,
EhloExtension,
DataLineFilter,
MessageHook {
    private static final String MESG_SIZE = "MESG_SIZE";
    private static final String MESG_FAILED = "MESG_FAILED";
    private static final String[] MAIL_PARAMS = new String[]{"SIZE"};
    private static final HookResult SYNTAX_ERROR = new HookResult(2, "501", DSNStatus.getStatus(5, "5.4") + " Syntactically incorrect value for SIZE parameter");
    private static final HookResult QUOTA_EXCEEDED = new HookResult(2, "552", DSNStatus.getStatus(5, "3.4") + " Message size exceeds fixed maximum message size");
    public static final int SINGLE_CHARACTER_LINE = 3;
    public static final int DOT_BYTE = 46;

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    @Override
    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        return this.doMailSize(session, paramValue, (String)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction));
    }

    @Override
    public String[] getMailParamNames() {
        return MAIL_PARAMS;
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        long maxMessageSize = session.getConfiguration().getMaxMessageSize();
        if (maxMessageSize > 0L) {
            return Arrays.asList("SIZE " + maxMessageSize);
        }
        return Collections.EMPTY_LIST;
    }

    private HookResult doMailSize(SMTPSession session, String mailOptionValue, String tempSender) {
        long maxMessageSize;
        int size = 0;
        try {
            size = Integer.parseInt(mailOptionValue);
        }
        catch (NumberFormatException pe) {
            session.getLogger().error("Rejected syntactically incorrect value for SIZE parameter.");
            return SYNTAX_ERROR;
        }
        if (session.getLogger().isDebugEnabled()) {
            StringBuilder debugBuffer = new StringBuilder(128).append("MAIL command option SIZE received with value ").append(size).append(".");
            session.getLogger().debug(debugBuffer.toString());
        }
        if ((maxMessageSize = session.getConfiguration().getMaxMessageSize()) > 0L && (long)size > maxMessageSize) {
            StringBuilder errorBuffer = new StringBuilder(256).append("Rejected message from ").append(tempSender != null ? tempSender : null).append(" from ").append(session.getRemoteAddress().getAddress().getHostAddress()).append(" of size ").append(size).append(" exceeding system maximum message size of ").append(maxMessageSize).append("based on SIZE option.");
            session.getLogger().error(errorBuffer.toString());
            return QUOTA_EXCEEDED;
        }
        session.setAttachment(MESG_SIZE, size, ProtocolSession.State.Transaction);
        return null;
    }

    @Override
    public Response onLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        Boolean failed = (Boolean)session.getAttachment(MESG_FAILED, ProtocolSession.State.Transaction);
        if (failed != null && failed.booleanValue()) {
            if (this.isDataTerminated(line)) {
                line.rewind();
                next.onLine((ProtocolSession)session, line);
                return new SMTPResponse("552", "Quota exceeded");
            }
            return null;
        }
        if (this.isDataTerminated(line)) {
            line.rewind();
            return next.onLine((ProtocolSession)session, line);
        }
        line.rewind();
        Long currentSize = (Long)session.getAttachment("CURRENT_SIZE", ProtocolSession.State.Transaction);
        Long newSize = currentSize == null ? Long.valueOf(line.remaining()) : Long.valueOf(currentSize.intValue() + line.remaining());
        session.setAttachment("CURRENT_SIZE", newSize, ProtocolSession.State.Transaction);
        if (session.getConfiguration().getMaxMessageSize() > 0L && (long)newSize.intValue() > session.getConfiguration().getMaxMessageSize()) {
            session.setAttachment(MESG_FAILED, Boolean.TRUE, ProtocolSession.State.Transaction);
            return null;
        }
        line.rewind();
        return next.onLine((ProtocolSession)session, line);
    }

    private boolean isDataTerminated(ByteBuffer line) {
        return line.remaining() == 3 && line.get() == 46;
    }

    @Override
    public HookResult onMessage(SMTPSession session, MailEnvelope mail) {
        Boolean failed = (Boolean)session.getAttachment(MESG_FAILED, ProtocolSession.State.Transaction);
        if (failed != null && failed.booleanValue()) {
            StringBuilder errorBuffer = new StringBuilder(256).append("Rejected message from ").append(session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction).toString()).append(" from ").append(session.getRemoteAddress().getAddress().getHostAddress()).append(" exceeding system maximum message size of ").append(session.getConfiguration().getMaxMessageSize());
            session.getLogger().error(errorBuffer.toString());
            return QUOTA_EXCEEDED;
        }
        return HookResult.declined();
    }
}

