/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.MailEnvelopeImpl;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.MessageHook;

public class DataLineMessageHookHandler
implements DataLineFilter,
ExtensibleHandler {
    private static final Response ERROR_PROCESSING_MESSAGE = new SMTPResponse("451", DSNStatus.getStatus(4, "0.0") + " Error processing message").immutable();
    private List<?> messageHandlers;
    private List<?> rHooks;

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    @Override
    public Response onLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        MailEnvelopeImpl env = (MailEnvelopeImpl)session.getAttachment("MAILENV", ProtocolSession.State.Transaction);
        OutputStream out = env.getMessageOutputStream();
        try {
            byte c = line.get();
            if (line.remaining() == 2 && c == 46) {
                out.flush();
                out.close();
                Response response = this.processExtensions(session, env);
                session.popLineHandler();
                session.resetState();
                return response;
            }
            if (c == 46 && line.get() == 46) {
                byte[] bline = this.readBytes(line);
                out.write(bline, 1, bline.length - 1);
            } else {
                out.write(this.readBytes(line));
            }
            out.flush();
        }
        catch (IOException e) {
            session.getLogger().error("Unknown error occurred while processing DATA.", (Throwable)e);
            session.resetState();
            return ERROR_PROCESSING_MESSAGE;
        }
        return null;
    }

    private byte[] readBytes(ByteBuffer line) {
        byte[] bline;
        line.rewind();
        if (line.hasArray()) {
            bline = line.array();
        } else {
            bline = new byte[line.remaining()];
            line.get(bline);
        }
        return bline;
    }

    protected Response processExtensions(SMTPSession session, MailEnvelopeImpl mail) {
        if (mail != null && this.messageHandlers != null) {
            for (Object messageHandler : this.messageHandlers) {
                SMTPResponse response;
                MessageHook rawHandler = (MessageHook)messageHandler;
                session.getLogger().debug("executing message handler " + rawHandler);
                long start = System.currentTimeMillis();
                HookResult hRes = rawHandler.onMessage(session, mail);
                long executionTime = System.currentTimeMillis() - start;
                if (this.rHooks != null) {
                    for (Object rHook : this.rHooks) {
                        session.getLogger().debug("executing hook " + rHook);
                        hRes = ((HookResultHook)rHook).onHookResult(session, hRes, executionTime, rawHandler);
                    }
                }
                if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse(hRes)) == null) continue;
                return response;
            }
            return AbstractHookableCmdHandler.calcDefaultSMTPResponse(new HookResult(2));
        }
        return null;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (MessageHook.class.equals((Object)interfaceName)) {
            this.messageHandlers = extension;
            this.checkMessageHookCount(this.messageHandlers);
        } else if (HookResultHook.class.equals((Object)interfaceName)) {
            this.rHooks = extension;
        }
    }

    protected void checkMessageHookCount(List<?> messageHandlers) throws WiringException {
        if (messageHandlers.size() == 0) {
            throw new WiringException("No messageHandler configured");
        }
    }

    public List<Class<?>> getMarkerInterfaces() {
        LinkedList classes = new LinkedList();
        classes.add(MessageHook.class);
        classes.add(HookResultHook.class);
        return classes;
    }
}

