/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.MailEnvelopeImpl;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;

public class DataCmdHandler
implements CommandHandler<SMTPSession>,
ExtensibleHandler {
    private static final Response NO_RECIPIENT = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " No recipients specified").immutable();
    private static final Response NO_SENDER = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " No sender specified").immutable();
    private static final Response UNEXPECTED_ARG = new SMTPResponse("500", DSNStatus.getStatus(5, "5.4") + " Unexpected argument provided with DATA command").immutable();
    private static final Response DATA_READY = new SMTPResponse("354", "Ok Send data ending with <CRLF>.<CRLF>").immutable();
    private static final Collection<String> COMMANDS = Collections.unmodifiableCollection(Arrays.asList("DATA"));
    public static final String MAILENV = "MAILENV";
    private final MetricFactory metricFactory;
    private LineHandler<SMTPSession> lineHandler;

    @Inject
    public DataCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onCommand(SMTPSession session, Request request) {
        TimeMetric timeMetric = this.metricFactory.timer("SMTP-" + request.getCommand());
        session.stopDetectingCommandInjection();
        try {
            String parameters = request.getArgument();
            Response response = this.doDATAFilter(session, parameters);
            if (response == null) {
                Response response2 = this.doDATA(session, parameters);
                return response2;
            }
            Response response3 = response;
            return response3;
        }
        finally {
            timeMetric.stopAndPublish();
            session.needsCommandInjectionDetection();
        }
    }

    protected Response doDATA(SMTPSession session, String argument) {
        MailEnvelope env = this.createEnvelope(session, (MailAddress)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction), new ArrayList<MailAddress>((Collection)session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction)));
        session.setAttachment(MAILENV, env, ProtocolSession.State.Transaction);
        session.pushLineHandler(this.lineHandler);
        return DATA_READY;
    }

    protected MailEnvelope createEnvelope(SMTPSession session, MailAddress sender, List<MailAddress> recipients) {
        MailEnvelopeImpl env = new MailEnvelopeImpl();
        env.setRecipients(recipients);
        env.setSender(sender);
        return env;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    public List getMarkerInterfaces() {
        LinkedList<Class<DataLineFilter>> classes = new LinkedList<Class<DataLineFilter>>();
        classes.add(DataLineFilter.class);
        return classes;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (DataLineFilter.class.equals((Object)interfaceName)) {
            Object lineHandler = new DataConsumerLineHandler();
            for (int i = extension.size() - 1; i >= 0; --i) {
                lineHandler = new DataLineFilterWrapper((DataLineFilter)extension.get(i), (LineHandler<SMTPSession>)lineHandler);
            }
            this.lineHandler = lineHandler;
        }
    }

    protected Response doDATAFilter(SMTPSession session, String argument) {
        if (argument != null && argument.length() > 0) {
            return UNEXPECTED_ARG;
        }
        if (session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction) == null) {
            return NO_SENDER;
        }
        if (session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction) == null) {
            return NO_RECIPIENT;
        }
        return null;
    }

    protected LineHandler<SMTPSession> getLineHandler() {
        return this.lineHandler;
    }

    public static final class DataLineFilterWrapper
    implements LineHandler<SMTPSession> {
        private final DataLineFilter filter;
        private final LineHandler<SMTPSession> next;

        public DataLineFilterWrapper(DataLineFilter filter, LineHandler<SMTPSession> next) {
            this.filter = filter;
            this.next = next;
        }

        public Response onLine(SMTPSession session, ByteBuffer line) {
            line.rewind();
            return this.filter.onLine(session, line, this.next);
        }

        public void init(Configuration config) throws ConfigurationException {
        }

        public void destroy() {
        }
    }

    public static final class DataConsumerLineHandler
    implements LineHandler<SMTPSession> {
        public SMTPResponse onLine(SMTPSession session, ByteBuffer line) {
            if (line.remaining() == 3 && line.get() == 46) {
                session.popLineHandler();
            }
            return null;
        }

        public void init(Configuration config) throws ConfigurationException {
        }

        public void destroy() {
        }
    }
}

