/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.Locale;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;

public abstract class AbstractSenderAuthIdentifyVerificationRcptHook
implements RcptHook {
    private static final HookResult INVALID_AUTH = new HookResult(2, "503", DSNStatus.getStatus(5, "7.1") + " Incorrect Authentication for Specified Email Address");

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        if (session.getUser() != null) {
            String authUser = session.getUser().toLowerCase(Locale.US);
            MailAddress senderAddress = (MailAddress)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction);
            String username = null;
            if (senderAddress != null) {
                username = this.useVirtualHosting() ? senderAddress.toString() : senderAddress.getLocalPart();
            }
            if (senderAddress == null || !authUser.equalsIgnoreCase(username) || !this.isLocalDomain(senderAddress.getDomain())) {
                return INVALID_AUTH;
            }
        }
        return HookResult.declined();
    }

    protected abstract boolean isLocalDomain(String var1);

    protected abstract boolean useVirtualHosting();
}

