/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;

public abstract class AbstractHookableCmdHandler<Hook extends Hook>
implements CommandHandler<SMTPSession>,
ExtensibleHandler {
    private final MetricFactory metricFactory;
    private List<Hook> hooks;
    private List<HookResultHook> rHooks;

    @Inject
    public AbstractHookableCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onCommand(SMTPSession session, Request request) {
        TimeMetric timeMetric = this.metricFactory.timer("SMTP-" + request.getCommand().toLowerCase(Locale.US));
        String command = request.getCommand();
        String parameters = request.getArgument();
        Response response = this.doFilterChecks(session, command, parameters);
        try {
            if (response == null) {
                response = this.processHooks(session, command, parameters);
                if (response == null) {
                    Response response2 = this.doCoreCmd(session, command, parameters);
                    return response2;
                }
                Response response3 = response;
                return response3;
            }
            Response response4 = response;
            return response4;
        }
        finally {
            timeMetric.stopAndPublish();
        }
    }

    private Response processHooks(SMTPSession session, String command, String parameters) {
        List<Hook> hooks = this.getHooks();
        if (hooks != null) {
            int count = hooks.size();
            for (int i = 0; i < count; ++i) {
                Hook rawHook = (Hook)hooks.get(i);
                session.getLogger().debug("executing hook " + rawHook.getClass().getName());
                long start = System.currentTimeMillis();
                HookResult hRes = this.callHook(rawHook, session, parameters);
                long executionTime = System.currentTimeMillis() - start;
                if (this.rHooks != null) {
                    for (HookResultHook rHook : this.rHooks) {
                        session.getLogger().debug("executing hook " + rHook);
                        hRes = rHook.onHookResult(session, hRes, executionTime, rawHook);
                    }
                }
                if ((hRes.getResult() & 1) == 1) {
                    final Response response = this.doCoreCmd(session, command, parameters);
                    if ((hRes.getResult() & 0x10) == 16) {
                        return new Response(){

                            public boolean isEndSession() {
                                return true;
                            }

                            public String getRetCode() {
                                return response.getRetCode();
                            }

                            public List<CharSequence> getLines() {
                                return response.getLines();
                            }
                        };
                    }
                    return response;
                }
                SMTPResponse res = AbstractHookableCmdHandler.calcDefaultSMTPResponse(hRes);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    protected abstract HookResult callHook(Hook var1, SMTPSession var2, String var3);

    public static SMTPResponse calcDefaultSMTPResponse(HookResult result) {
        if (result != null) {
            int rCode = result.getResult();
            String smtpRetCode = result.getSmtpRetCode();
            String smtpDesc = result.getSmtpDescription();
            if ((rCode & 2) == 2) {
                if (smtpRetCode == null) {
                    smtpRetCode = "554";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Email rejected";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                if ((rCode & 0x10) == 16) {
                    response.setEndSession(true);
                }
                return response;
            }
            if ((rCode & 4) == 4) {
                if (smtpRetCode == null) {
                    smtpRetCode = "451";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Temporary problem. Please try again later";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                if ((rCode & 0x10) == 16) {
                    response.setEndSession(true);
                }
                return response;
            }
            if ((rCode & 1) == 1) {
                if (smtpRetCode == null) {
                    smtpRetCode = "250";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Command accepted";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                if ((rCode & 0x10) == 16) {
                    response.setEndSession(true);
                }
                return response;
            }
            if ((rCode & 0x10) == 16) {
                if (smtpRetCode == null) {
                    smtpRetCode = "554";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Server disconnected";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                response.setEndSession(true);
                return response;
            }
            return null;
        }
        return null;
    }

    protected abstract Response doFilterChecks(SMTPSession var1, String var2, String var3);

    protected abstract Response doCoreCmd(SMTPSession var1, String var2, String var3);

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList classes = new ArrayList(2);
        classes.add(this.getHookInterface());
        classes.add(HookResultHook.class);
        return classes;
    }

    protected abstract Class<Hook> getHookInterface();

    public void wireExtensions(Class<?> interfaceName, List<?> extension) {
        if (this.getHookInterface().equals(interfaceName)) {
            this.hooks = extension;
        } else if (HookResultHook.class.equals(interfaceName)) {
            this.rHooks = extension;
        }
    }

    protected List<Hook> getHooks() {
        return this.hooks;
    }
}

