/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;

public abstract class AbstractAuthRequiredToRelayRcptHook
implements RcptHook {
    private static final HookResult AUTH_REQUIRED = new HookResult(2, "530", DSNStatus.getStatus(5, "7.1") + " Authentication Required");
    private static final HookResult RELAYING_DENIED = new HookResult(2, "550", DSNStatus.getStatus(5, "7.1") + " Requested action not taken: relaying denied");

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        String toDomain;
        if (!session.isRelayingAllowed() && !this.isLocalDomain(toDomain = rcpt.getDomain())) {
            if (session.isAuthSupported()) {
                return AUTH_REQUIRED;
            }
            return RELAYING_DENIED;
        }
        return HookResult.declined();
    }

    protected abstract boolean isLocalDomain(String var1);
}

