/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.handler.CommandDispatcher;
import org.apache.james.protocols.api.handler.CommandHandlerResultLogger;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChainImpl;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.core.DataCmdHandler;
import org.apache.james.protocols.smtp.core.DataLineMessageHookHandler;
import org.apache.james.protocols.smtp.core.ExpnCmdHandler;
import org.apache.james.protocols.smtp.core.HeloCmdHandler;
import org.apache.james.protocols.smtp.core.HelpCmdHandler;
import org.apache.james.protocols.smtp.core.MailCmdHandler;
import org.apache.james.protocols.smtp.core.NoopCmdHandler;
import org.apache.james.protocols.smtp.core.PostmasterAbuseRcptHook;
import org.apache.james.protocols.smtp.core.QuitCmdHandler;
import org.apache.james.protocols.smtp.core.RcptCmdHandler;
import org.apache.james.protocols.smtp.core.ReceivedDataLineFilter;
import org.apache.james.protocols.smtp.core.RsetCmdHandler;
import org.apache.james.protocols.smtp.core.UnknownCmdHandler;
import org.apache.james.protocols.smtp.core.VrfyCmdHandler;
import org.apache.james.protocols.smtp.core.WelcomeMessageHandler;
import org.apache.james.protocols.smtp.core.esmtp.AuthCmdHandler;
import org.apache.james.protocols.smtp.core.esmtp.EhloCmdHandler;
import org.apache.james.protocols.smtp.core.esmtp.MailSizeEsmtpExtension;
import org.apache.james.protocols.smtp.core.esmtp.StartTlsCmdHandler;
import org.apache.james.protocols.smtp.hook.AuthHook;
import org.apache.james.protocols.smtp.hook.Hook;

public class SMTPProtocolHandlerChain
extends ProtocolHandlerChainImpl {
    private final MetricFactory metricFactory;

    public SMTPProtocolHandlerChain(MetricFactory metricFactory) {
        this(metricFactory, true);
    }

    public SMTPProtocolHandlerChain(MetricFactory metricFactory, boolean addDefault) {
        this.metricFactory = metricFactory;
        if (addDefault) {
            this.addAll(this.initDefaultHandlers());
        }
    }

    public SMTPProtocolHandlerChain(MetricFactory metricFactory, Hook ... hooks) throws WiringException {
        this(metricFactory, true);
        for (Hook hook : hooks) {
            this.add(hook);
        }
        this.wireExtensibleHandlers();
    }

    protected List<ProtocolHandler> initDefaultHandlers() {
        ArrayList<ProtocolHandler> defaultHandlers = new ArrayList<ProtocolHandler>();
        defaultHandlers.add((ProtocolHandler)new CommandDispatcher());
        defaultHandlers.add((ProtocolHandler)new ExpnCmdHandler());
        defaultHandlers.add((ProtocolHandler)new EhloCmdHandler(this.metricFactory));
        defaultHandlers.add((ProtocolHandler)new HeloCmdHandler(this.metricFactory));
        defaultHandlers.add((ProtocolHandler)new HelpCmdHandler());
        defaultHandlers.add((ProtocolHandler)new MailCmdHandler(this.metricFactory));
        defaultHandlers.add((ProtocolHandler)new NoopCmdHandler());
        defaultHandlers.add((ProtocolHandler)new QuitCmdHandler(this.metricFactory));
        defaultHandlers.add((ProtocolHandler)new RcptCmdHandler(this.metricFactory));
        defaultHandlers.add((ProtocolHandler)new RsetCmdHandler());
        defaultHandlers.add((ProtocolHandler)new VrfyCmdHandler());
        defaultHandlers.add((ProtocolHandler)new DataCmdHandler(this.metricFactory));
        defaultHandlers.add(new MailSizeEsmtpExtension());
        defaultHandlers.add((ProtocolHandler)new WelcomeMessageHandler());
        defaultHandlers.add(new PostmasterAbuseRcptHook());
        defaultHandlers.add(new ReceivedDataLineFilter());
        defaultHandlers.add(new DataLineMessageHookHandler());
        defaultHandlers.add((ProtocolHandler)new StartTlsCmdHandler());
        defaultHandlers.add((ProtocolHandler)new UnknownCmdHandler(this.metricFactory));
        defaultHandlers.add((ProtocolHandler)new CommandHandlerResultLogger());
        return defaultHandlers;
    }

    private synchronized boolean checkForAuth(ProtocolHandler handler) {
        if (this.isReadyOnly()) {
            throw new UnsupportedOperationException("Read-Only");
        }
        if (handler instanceof AuthHook) {
            LinkedList handlers = this.getHandlers(ExtensibleHandler.class);
            for (ExtensibleHandler h : handlers) {
                if (!h.getMarkerInterfaces().contains(AuthHook.class)) continue;
                return true;
            }
            if (!this.add(new AuthCmdHandler())) {
                return false;
            }
        }
        return true;
    }

    public boolean add(ProtocolHandler handler) {
        this.checkForAuth(handler);
        return super.add(handler);
    }

    public boolean addAll(Collection<? extends ProtocolHandler> c) {
        for (ProtocolHandler protocolHandler : c) {
            if (this.checkForAuth(protocolHandler)) continue;
            return false;
        }
        return super.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends ProtocolHandler> c) {
        for (ProtocolHandler protocolHandler : c) {
            if (this.checkForAuth(protocolHandler)) continue;
            return false;
        }
        return super.addAll(index, c);
    }

    public void add(int index, ProtocolHandler element) {
        this.checkForAuth(element);
        super.add(index, element);
    }
}

