/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import java.util.Locale;
import org.apache.james.protocols.smtp.MailAddressException;

public class MailAddress {
    private static final char[] SPECIAL = new char[]{'<', '>', '(', ')', '[', ']', '\\', '.', ',', ';', ':', '@', '\"'};
    private String localPart = null;
    private String domain = null;
    private static final MailAddress NULL_SENDER = new MailAddress(){

        @Override
        public String getDomain() {
            return "";
        }

        @Override
        public String getLocalPart() {
            return "";
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public boolean isNullSender() {
            return true;
        }
    };

    private int stripSourceRoute(String address, int pos) {
        int i;
        if (pos < address.length() && address.charAt(pos) == '@' && (i = address.indexOf(58)) != -1) {
            pos = i + 1;
        }
        return pos;
    }

    public static MailAddress nullSender() {
        return NULL_SENDER;
    }

    private MailAddress() {
    }

    public MailAddress(String address) throws MailAddressException {
        address = address.trim();
        int pos = 0;
        this.stripSourceRoute(address, pos);
        StringBuffer localPartSB = new StringBuffer();
        StringBuffer domainSB = new StringBuffer();
        try {
            if (address.charAt(pos) == '\"') {
                pos = this.parseQuotedLocalPart(localPartSB, address, pos);
                if (localPartSB.toString().length() == 2) {
                    throw new MailAddressException("No quoted local-part (user account) found at position " + (pos + 2) + " in '" + address + "'", address, pos + 2);
                }
            } else {
                pos = this.parseUnquotedLocalPart(localPartSB, address, pos);
                if (localPartSB.toString().length() == 0) {
                    throw new MailAddressException("No local-part (user account) found at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
            }
            if (pos >= address.length() || address.charAt(pos) != '@') {
                throw new MailAddressException("Did not find @ between local-part and domain at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            ++pos;
            while ((pos = address.charAt(pos) == '#' ? this.parseNumber(domainSB, address, pos) : (address.charAt(pos) == '[' ? this.parseDomainLiteral(domainSB, address, pos) : this.parseDomain(domainSB, address, pos))) < address.length() && address.charAt(pos) == '.') {
                domainSB.append('.');
                ++pos;
            }
            if (domainSB.toString().length() == 0) {
                throw new MailAddressException("No domain found at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new MailAddressException("Out of data at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        this.localPart = localPartSB.toString();
        this.domain = domainSB.toString();
    }

    public MailAddress(String localPart, String domain) throws MailAddressException {
        this(localPart + "@" + domain);
    }

    public String getDomain() {
        if (!this.domain.startsWith("[") || !this.domain.endsWith("]")) {
            return this.domain;
        }
        return this.domain.substring(1, this.domain.length() - 1);
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String toString() {
        StringBuffer addressBuffer = new StringBuffer(128).append(this.localPart).append("@").append(this.domain);
        return addressBuffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            String theString = (String)obj;
            return this.toString().equalsIgnoreCase(theString);
        }
        if (obj instanceof MailAddress) {
            MailAddress addr = (MailAddress)obj;
            return this.getLocalPart().equalsIgnoreCase(addr.getLocalPart()) && this.getDomain().equalsIgnoreCase(addr.getDomain());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().toLowerCase(Locale.US).hashCode();
    }

    private int parseQuotedLocalPart(StringBuffer lpSB, String address, int pos) throws MailAddressException {
        StringBuffer resultSB = new StringBuffer();
        resultSB.append('\"');
        ++pos;
        while (true) {
            if (address.charAt(pos) == '\"') break;
            if (address.charAt(pos) == '\\') {
                resultSB.append('\\');
                char x = address.charAt(++pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new MailAddressException("Invalid \\ syntaxed character at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
                resultSB.append(x);
                ++pos;
                continue;
            }
            char q = address.charAt(pos);
            if (q <= '\u0000' || q == '\n' || q == '\r' || q == '\"' || q == '\\') {
                throw new MailAddressException("Unquoted local-part (user account) must be one of the 128 ASCI characters exception <CR>, <LF>, quote (\"), or backslash (\\) at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            resultSB.append(q);
            ++pos;
        }
        resultSB.append('\"');
        lpSB.append(resultSB);
        return ++pos;
    }

    private int parseUnquotedLocalPart(StringBuffer lpSB, String address, int pos) throws MailAddressException {
        StringBuffer resultSB = new StringBuffer();
        boolean lastCharDot = false;
        while (true) {
            if (address.charAt(pos) == '\\') {
                resultSB.append('\\');
                char x = address.charAt(++pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new MailAddressException("Invalid \\ syntaxed character at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
                resultSB.append(x);
                ++pos;
                lastCharDot = false;
                continue;
            }
            if (address.charAt(pos) == '.') {
                resultSB.append('.');
                ++pos;
                lastCharDot = true;
                continue;
            }
            if (address.charAt(pos) == '@') break;
            char c = address.charAt(pos);
            if (c <= '\u001f' || c >= '\u007f' || c == ' ') {
                throw new MailAddressException("Invalid character in local-part (user account) at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            for (char aChar : SPECIAL) {
                if (c != aChar) continue;
                throw new MailAddressException("Invalid character in local-part (user account) at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            resultSB.append(c);
            ++pos;
            lastCharDot = false;
        }
        if (lastCharDot) {
            throw new MailAddressException("local-part (user account) ended with a \".\", which is invalid in address '" + address + "'", address, pos);
        }
        lpSB.append(resultSB);
        return pos;
    }

    private int parseNumber(StringBuffer dSB, String address, int pos) throws MailAddressException {
        char d;
        StringBuffer resultSB = new StringBuffer();
        while (pos < address.length() && (d = address.charAt(pos)) != '.') {
            if (d < '0' || d > '9') {
                throw new MailAddressException("In domain, did not find a number in # address at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            resultSB.append(d);
            ++pos;
        }
        dSB.append(resultSB);
        return pos;
    }

    private int parseDomainLiteral(StringBuffer dSB, String address, int pos) throws MailAddressException {
        while (address.contains("\\")) {
            address = address.substring(0, address.indexOf("\\")) + address.substring(address.indexOf("\\") + 1);
        }
        StringBuffer resultSB = new StringBuffer();
        resultSB.append(address.charAt(pos));
        ++pos;
        for (int octet = 0; octet < 4; ++octet) {
            char d;
            StringBuffer snumSB = new StringBuffer();
            for (int digits = 0; digits < 3 && (d = address.charAt(pos)) != '.' && d != ']'; ++digits) {
                if (d < '0' || d > '9') {
                    throw new MailAddressException("Invalid number at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
                snumSB.append(d);
                ++pos;
            }
            if (snumSB.toString().length() == 0) {
                throw new MailAddressException("Number not found at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            try {
                int snum = Integer.parseInt(snumSB.toString());
                if (snum > 255) {
                    throw new MailAddressException("Invalid number at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
            }
            catch (NumberFormatException nfe) {
                throw new MailAddressException("Invalid number at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            resultSB.append(snumSB.toString());
            if (address.charAt(pos) == ']') {
                if (octet >= 3) break;
                throw new MailAddressException("End of number reached too quickly at " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            if (address.charAt(pos) != '.') continue;
            resultSB.append('.');
            ++pos;
        }
        if (address.charAt(pos) != ']') {
            throw new MailAddressException("Did not find closing bracket \"]\" in domain at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        resultSB.append(']');
        dSB.append(resultSB);
        return ++pos;
    }

    private int parseDomain(StringBuffer dSB, String address, int pos) throws MailAddressException {
        String result;
        StringBuffer resultSB = new StringBuffer();
        while (pos < address.length()) {
            char ch = address.charAt(pos);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '-') {
                resultSB.append(ch);
                ++pos;
                continue;
            }
            if (ch == '.') break;
            throw new MailAddressException("Invalid character at " + pos + " in '" + address + "'", address, pos);
        }
        if ((result = resultSB.toString()).startsWith("-") || result.endsWith("-")) {
            throw new MailAddressException("Domain name cannot begin or end with a hyphen \"-\" at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        dSB.append(result);
        return pos;
    }

    public boolean isNullSender() {
        return false;
    }
}

