/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.Locale;
import org.apache.james.protocols.smtp.CommandInjectionDetectedException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;

public class AllButStartTlsDelimiterChannelHandler
extends DelimiterBasedFrameDecoder {
    private static final String STARTTLS = "starttls";
    private final ChannelPipeline pipeline;

    public AllButStartTlsDelimiterChannelHandler(ChannelPipeline pipeline, int maxFrameLength, boolean stripDelimiter, ChannelBuffer[] delimiters) {
        super(maxFrameLength, stripDelimiter, delimiters);
        this.pipeline = pipeline;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        String trimedLowerCasedInput;
        SMTPSession session = (SMTPSession)this.pipeline.getContext("coreHandler").getAttachment();
        if ((session == null || session.needsCommandInjectionDetection()) && this.hasCommandInjection(trimedLowerCasedInput = this.readAll(buffer).trim().toLowerCase(Locale.US))) {
            throw new CommandInjectionDetectedException();
        }
        return super.decode(ctx, channel, buffer);
    }

    private String readAll(ChannelBuffer buffer) {
        return buffer.toString(Charsets.US_ASCII);
    }

    private boolean hasCommandInjection(String trimedLowerCasedInput) {
        List parts = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).omitEmptyStrings().splitToList((CharSequence)trimedLowerCasedInput);
        return this.hasInvalidStartTlsPart(parts) || this.multiPartsAndOneStartTls(parts);
    }

    private boolean multiPartsAndOneStartTls(List<String> parts) {
        return FluentIterable.from(parts).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String line) {
                return line.startsWith(AllButStartTlsDelimiterChannelHandler.STARTTLS);
            }
        }) && parts.size() > 1;
    }

    private boolean hasInvalidStartTlsPart(List<String> parts) {
        return FluentIterable.from(parts).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String line) {
                return line.startsWith(AllButStartTlsDelimiterChannelHandler.STARTTLS) && !line.endsWith(AllButStartTlsDelimiterChannelHandler.STARTTLS);
            }
        });
    }
}

