/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.james.protocols.api.handler.AbstractProtocolHandlerChain;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.WiringException;

public class ProtocolHandlerChainImpl
extends AbstractProtocolHandlerChain
implements List<ProtocolHandler> {
    private final List<ProtocolHandler> handlers = new ArrayList<ProtocolHandler>();
    private volatile boolean readyOnly = false;

    @Override
    public void wireExtensibleHandlers() throws WiringException {
        super.wireExtensibleHandlers();
        this.readyOnly = true;
    }

    protected final boolean isReadyOnly() {
        return this.readyOnly;
    }

    @Override
    public boolean add(ProtocolHandler handler) {
        this.checkReadOnly();
        return this.handlers.add(handler);
    }

    @Override
    protected List<ProtocolHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    @Override
    public int size() {
        return this.handlers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.handlers.contains(o);
    }

    @Override
    public Iterator<ProtocolHandler> iterator() {
        return new ProtocolHandlerIterator(this.handlers.listIterator());
    }

    @Override
    public Object[] toArray() {
        return this.handlers.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.handlers.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        this.checkReadOnly();
        return this.handlers.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.handlers.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends ProtocolHandler> c) {
        this.checkReadOnly();
        return this.handlers.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ProtocolHandler> c) {
        this.checkReadOnly();
        return this.handlers.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkReadOnly();
        return this.handlers.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.handlers.retainAll(c);
    }

    @Override
    public void clear() {
        this.checkReadOnly();
        this.handlers.clear();
    }

    @Override
    public ProtocolHandler get(int index) {
        return this.handlers.get(index);
    }

    @Override
    public ProtocolHandler set(int index, ProtocolHandler element) {
        this.checkReadOnly();
        return this.handlers.set(index, element);
    }

    @Override
    public void add(int index, ProtocolHandler element) {
        this.checkReadOnly();
        this.handlers.add(index, element);
    }

    @Override
    public ProtocolHandler remove(int index) {
        this.checkReadOnly();
        return this.handlers.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.handlers.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.handlers.lastIndexOf(o);
    }

    @Override
    public ListIterator<ProtocolHandler> listIterator() {
        return new ProtocolHandlerIterator(this.handlers.listIterator());
    }

    @Override
    public ListIterator<ProtocolHandler> listIterator(int index) {
        return new ProtocolHandlerIterator(this.handlers.listIterator(index));
    }

    @Override
    public List<ProtocolHandler> subList(int fromIndex, int toIndex) {
        ArrayList<ProtocolHandler> sList = new ArrayList<ProtocolHandler>();
        for (ProtocolHandler handler : this.handlers.subList(fromIndex, toIndex)) {
            sList.add(handler);
        }
        if (this.readyOnly) {
            return Collections.unmodifiableList(sList);
        }
        return sList;
    }

    private void checkReadOnly() {
        if (this.readyOnly) {
            throw new UnsupportedOperationException("Ready-only");
        }
    }

    private final class ProtocolHandlerIterator
    implements ListIterator<ProtocolHandler> {
        private final ListIterator<ProtocolHandler> handlers;

        public ProtocolHandlerIterator(ListIterator<ProtocolHandler> handlers) {
            this.handlers = handlers;
        }

        @Override
        public boolean hasNext() {
            return this.handlers.hasNext();
        }

        @Override
        public ProtocolHandler next() {
            return this.handlers.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.handlers.hasPrevious();
        }

        @Override
        public ProtocolHandler previous() {
            return this.handlers.previous();
        }

        @Override
        public int nextIndex() {
            return this.handlers.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.handlers.previousIndex();
        }

        @Override
        public void remove() {
            ProtocolHandlerChainImpl.this.checkReadOnly();
            this.handlers.previousIndex();
        }

        @Override
        public void set(ProtocolHandler e) {
            ProtocolHandlerChainImpl.this.checkReadOnly();
            this.handlers.set(e);
        }

        @Override
        public void add(ProtocolHandler e) {
            ProtocolHandlerChainImpl.this.checkReadOnly();
            this.handlers.add(e);
        }
    }
}

