/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api.handler;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.BaseRequest;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.future.FutureResponse;
import org.apache.james.protocols.api.future.FutureResponseImpl;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerResultHandler;
import org.apache.james.protocols.api.handler.WiringException;

public class CommandDispatcher<Session extends ProtocolSession>
implements ExtensibleHandler,
LineHandler<Session> {
    private final HashMap<String, List<CommandHandler<Session>>> commandHandlerMap = new HashMap();
    private final List<ProtocolHandlerResultHandler<Response, Session>> rHandlers = new ArrayList<ProtocolHandlerResultHandler<Response, Session>>();
    private final Collection<String> mandatoryCommands;

    public CommandDispatcher(Collection<String> mandatoryCommands) {
        this.mandatoryCommands = mandatoryCommands;
    }

    public CommandDispatcher() {
        this(Collections.emptyList());
    }

    @Override
    public void init(Configuration config) throws ConfigurationException {
    }

    @Override
    public void destroy() {
    }

    protected void addToMap(String commandName, CommandHandler<Session> cmdHandler) {
        List<CommandHandler<Session>> handlers = this.commandHandlerMap.get(commandName);
        if (handlers == null) {
            handlers = new ArrayList<CommandHandler<Session>>();
            this.commandHandlerMap.put(commandName, handlers);
        }
        handlers.add(cmdHandler);
    }

    protected List<CommandHandler<Session>> getCommandHandlers(String command, ProtocolSession session) {
        List<CommandHandler<Session>> handlers;
        if (command == null) {
            return null;
        }
        if (session.getLogger().isDebugEnabled()) {
            session.getLogger().debug("Lookup command handler for command: " + command);
        }
        if ((handlers = this.commandHandlerMap.get(command)) == null) {
            handlers = this.commandHandlerMap.get(this.getUnknownCommandHandlerIdentifier());
        }
        return handlers;
    }

    public void wireExtensions(Class interfaceName, List extensions) throws WiringException {
        if (interfaceName.equals(ProtocolHandlerResultHandler.class)) {
            this.rHandlers.addAll(extensions);
        }
        if (interfaceName.equals(CommandHandler.class)) {
            for (Object extension : extensions) {
                CommandHandler handler = (CommandHandler)extension;
                Collection<String> implCmds = handler.getImplCommands();
                for (String implCmd : implCmds) {
                    String commandName = implCmd.trim().toUpperCase(Locale.US);
                    this.addToMap(commandName, handler);
                }
            }
            if (this.commandHandlerMap.size() < 1) {
                throw new WiringException("No commandhandlers configured");
            }
            for (String cmd : this.mandatoryCommands) {
                if (this.commandHandlerMap.containsKey(cmd)) continue;
                throw new WiringException("No commandhandlers configured for mandatory command " + cmd);
            }
        }
    }

    @Override
    public Response onLine(Session session, ByteBuffer line) {
        try {
            Request request = this.parseRequest(session, line);
            if (request == null) {
                return null;
            }
            return this.dispatchCommandHandlers(session, request);
        }
        catch (Exception e) {
            session.getLogger().debug("Unable to parse request", e);
            return session.newFatalErrorResponse();
        }
    }

    protected Response dispatchCommandHandlers(Session session, Request request) {
        if (session.getLogger().isDebugEnabled()) {
            session.getLogger().debug(this.getClass().getName() + " received: " + request.getCommand());
        }
        List<CommandHandler<Session>> commandHandlers = this.getCommandHandlers(request.getCommand(), (ProtocolSession)session);
        for (CommandHandler<Session> commandHandler : commandHandlers) {
            long executionTime;
            long start = System.currentTimeMillis();
            Response response = commandHandler.onCommand(session, request);
            if (response == null || (response = this.executeResultHandlers(session, response, executionTime = System.currentTimeMillis() - start, commandHandler, this.rHandlers.iterator())) == null) continue;
            return response;
        }
        return null;
    }

    private Response executeResultHandlers(Session session, Response response, long executionTime, CommandHandler<Session> cHandler, final Iterator<ProtocolHandlerResultHandler<Response, Session>> resultHandlers) {
        if (resultHandlers.hasNext()) {
            if (response instanceof FutureResponse) {
                FutureResponseImpl futureResponse = new FutureResponseImpl();
                ((FutureResponse)response).addListener(new FutureResponse.ResponseListener((ProtocolSession)session, executionTime, cHandler, futureResponse){
                    final /* synthetic */ ProtocolSession val$session;
                    final /* synthetic */ long val$executionTime;
                    final /* synthetic */ CommandHandler val$cHandler;
                    final /* synthetic */ FutureResponseImpl val$futureResponse;
                    {
                        this.val$session = protocolSession;
                        this.val$executionTime = l;
                        this.val$cHandler = commandHandler;
                        this.val$futureResponse = futureResponseImpl;
                    }

                    @Override
                    public void onResponse(FutureResponse response) {
                        Response r = ((ProtocolHandlerResultHandler)resultHandlers.next()).onResponse(this.val$session, response, this.val$executionTime, this.val$cHandler);
                        r = CommandDispatcher.this.executeResultHandlers(this.val$session, r, this.val$executionTime, this.val$cHandler, resultHandlers);
                        this.val$futureResponse.setResponse(r);
                    }
                });
                return futureResponse;
            }
            response = resultHandlers.next().onResponse((ProtocolSession)session, response, executionTime, cHandler);
            return this.executeResultHandlers(session, response, executionTime, cHandler, resultHandlers);
        }
        return response;
    }

    protected Request parseRequest(Session session, ByteBuffer buffer) throws Exception {
        String curCommandName;
        byte[] line;
        String curCommandArgument = null;
        if (buffer.hasArray()) {
            line = buffer.array();
        } else {
            line = new byte[buffer.remaining()];
            buffer.get(line);
        }
        String cmdString = new String(line, session.getCharset().name()).trim();
        int spaceIndex = cmdString.indexOf(" ");
        if (spaceIndex > 0) {
            curCommandName = cmdString.substring(0, spaceIndex);
            curCommandArgument = cmdString.substring(spaceIndex + 1);
        } else {
            curCommandName = cmdString;
        }
        curCommandName = curCommandName.toUpperCase(Locale.US);
        return new BaseRequest(curCommandName, curCommandArgument);
    }

    @Override
    public List<Class<?>> getMarkerInterfaces() {
        LinkedList res = new LinkedList();
        res.add(CommandHandler.class);
        res.add(ProtocolHandlerResultHandler.class);
        return res;
    }

    protected String getUnknownCommandHandlerIdentifier() {
        return "UNKNOWN_CMD";
    }
}

