/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api.future;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.future.FutureResponse;
import org.apache.james.protocols.api.logger.Logger;

public class FutureResponseImpl
implements FutureResponse {
    private final Logger logger;
    protected Response response;
    private List<FutureResponse.ResponseListener> listeners;
    private int waiters;

    public FutureResponseImpl() {
        this(null);
    }

    public FutureResponseImpl(Logger logger) {
        this.logger = logger;
    }

    protected final synchronized void checkReady() {
        while (!this.isReady()) {
            try {
                ++this.waiters;
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                --this.waiters;
            }
        }
    }

    @Override
    public synchronized void addListener(FutureResponse.ResponseListener listener) {
        if (this.isReady()) {
            listener.onResponse(this);
        } else {
            if (this.listeners == null) {
                this.listeners = new ArrayList<FutureResponse.ResponseListener>();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeListener(FutureResponse.ResponseListener listener) {
        if (!this.isReady() && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public synchronized boolean isReady() {
        return this.response != null;
    }

    @Override
    public List<CharSequence> getLines() {
        this.checkReady();
        return this.response.getLines();
    }

    @Override
    public String getRetCode() {
        this.checkReady();
        return this.response.getRetCode();
    }

    @Override
    public boolean isEndSession() {
        this.checkReady();
        return this.response.isEndSession();
    }

    public synchronized String toString() {
        this.checkReady();
        return this.response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Response response) {
        boolean fire = false;
        FutureResponseImpl futureResponseImpl = this;
        synchronized (futureResponseImpl) {
            if (!this.isReady()) {
                this.response = response;
                boolean bl = fire = this.listeners != null;
                if (this.waiters > 0) {
                    this.notifyAll();
                }
            }
        }
        if (fire) {
            for (FutureResponse.ResponseListener listener : this.listeners) {
                try {
                    listener.onResponse(this);
                }
                catch (Throwable e) {
                    if (this.logger != null) {
                        this.logger.warn("An exception was thrown by the listener " + listener, e);
                        continue;
                    }
                    e.printStackTrace();
                }
            }
            this.listeners = null;
        }
    }
}

