/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.protocols.api.ProtocolConfiguration;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.logger.ContextualLogger;
import org.apache.james.protocols.api.logger.Logger;

public class ProtocolSessionImpl
implements ProtocolSession {
    private final Logger pLog;
    private final ProtocolTransport transport;
    private final Map<String, Object> connectionState;
    private final Map<String, Object> sessionState;
    private String user;
    protected final ProtocolConfiguration config;
    private static final Charset CHARSET = Charset.forName("US-ASCII");
    private static final String DELIMITER = "\r\n";

    public ProtocolSessionImpl(Logger logger, ProtocolTransport transport, ProtocolConfiguration config) {
        this.transport = transport;
        this.pLog = new ContextualLogger(this, logger);
        this.connectionState = new HashMap<String, Object>();
        this.sessionState = new HashMap<String, Object>();
        this.config = config;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.transport.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.transport.getRemoteAddress();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    public ProtocolTransport getProtocolTransport() {
        return this.transport;
    }

    @Override
    public boolean isStartTLSSupported() {
        return this.transport.isStartTLSSupported();
    }

    @Override
    public boolean isTLSStarted() {
        return this.transport.isTLSStarted();
    }

    @Override
    public Logger getLogger() {
        return this.pLog;
    }

    @Override
    public String getSessionID() {
        return this.transport.getId();
    }

    @Override
    public Map<String, Object> getConnectionState() {
        return this.connectionState;
    }

    @Override
    public Map<String, Object> getState() {
        return this.sessionState;
    }

    @Override
    public Response newLineTooLongResponse() {
        return null;
    }

    @Override
    public Response newFatalErrorResponse() {
        return null;
    }

    @Override
    public void resetState() {
        this.sessionState.clear();
    }

    @Override
    public ProtocolConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public Object setAttachment(String key, Object value, ProtocolSession.State state) {
        if (state == ProtocolSession.State.Connection) {
            if (value == null) {
                return this.connectionState.remove(key);
            }
            return this.connectionState.put(key, value);
        }
        if (value == null) {
            return this.sessionState.remove(key);
        }
        return this.sessionState.put(key, value);
    }

    @Override
    public Object getAttachment(String key, ProtocolSession.State state) {
        if (state == ProtocolSession.State.Connection) {
            return this.connectionState.get(key);
        }
        return this.sessionState.get(key);
    }

    @Override
    public Charset getCharset() {
        return CHARSET;
    }

    @Override
    public String getLineDelimiter() {
        return DELIMITER;
    }

    @Override
    public void popLineHandler() {
        this.transport.popLineHandler();
    }

    @Override
    public int getPushedLineHandlerCount() {
        return this.transport.getPushedLineHandlerCount();
    }

    @Override
    public <T extends ProtocolSession> void pushLineHandler(LineHandler<T> overrideCommandHandler) {
        this.transport.pushLineHandler(overrideCommandHandler, this);
    }
}

