/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.StartTlsResponse;
import org.apache.james.protocols.api.StreamResponse;
import org.apache.james.protocols.api.future.FutureResponse;

public abstract class AbstractProtocolTransport
implements ProtocolTransport {
    private static final String CRLF = "\r\n";
    private final Queue<Response> responses = new LinkedBlockingQueue<Response>();
    private volatile boolean isAsync = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeResponse(Response response, ProtocolSession session) {
        boolean enqueued = false;
        AbstractProtocolTransport abstractProtocolTransport = this;
        synchronized (abstractProtocolTransport) {
            if (this.isAsync) {
                this.responses.offer(response);
                enqueued = true;
            }
        }
        if (!enqueued) {
            if (this.isResponseWritable(response)) {
                this.writeResponseToClient(response, session);
            } else {
                this.addDequeuerListener(response, session);
                this.isAsync = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeQueuedResponses(ProtocolSession session) {
        block5: {
            Response queuedResponse;
            while (true) {
                queuedResponse = null;
                AbstractProtocolTransport abstractProtocolTransport = this;
                synchronized (abstractProtocolTransport) {
                    queuedResponse = this.responses.poll();
                    if (queuedResponse == null) {
                        this.isAsync = false;
                        break block5;
                    }
                }
                if (!this.isResponseWritable(queuedResponse)) break;
                this.writeResponseToClient(queuedResponse, session);
            }
            this.addDequeuerListener(queuedResponse, session);
        }
    }

    private boolean isResponseWritable(Response response) {
        return !(response instanceof FutureResponse) || ((FutureResponse)response).isReady();
    }

    private void addDequeuerListener(Response response, final ProtocolSession session) {
        ((FutureResponse)response).addListener(new FutureResponse.ResponseListener(){

            @Override
            public void onResponse(FutureResponse response) {
                AbstractProtocolTransport.this.writeResponseToClient(response, session);
                AbstractProtocolTransport.this.writeQueuedResponses(session);
            }
        });
    }

    protected void writeResponseToClient(Response response, ProtocolSession session) {
        if (response != null) {
            boolean startTLS = false;
            if (response instanceof StartTlsResponse) {
                if (this.isStartTLSSupported()) {
                    startTLS = true;
                } else {
                    throw new UnsupportedOperationException("StartTls is not supported by this ProtocolTransport implementation");
                }
            }
            if (response instanceof StreamResponse) {
                this.writeToClient(AbstractProtocolTransport.toBytes(response), session, false);
                this.writeToClient(((StreamResponse)response).getStream(), session, startTLS);
            } else {
                this.writeToClient(AbstractProtocolTransport.toBytes(response), session, startTLS);
            }
            if (startTLS) {
                session.resetState();
            }
            if (response.isEndSession()) {
                this.close();
            }
        }
    }

    protected static byte[] toBytes(Response response) {
        StringBuilder builder = new StringBuilder();
        List<CharSequence> lines = response.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            builder.append(lines.get(i));
            if (i >= lines.size()) continue;
            builder.append(CRLF);
        }
        try {
            return builder.toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No US-ASCII ?");
        }
    }

    protected abstract void writeToClient(byte[] var1, ProtocolSession var2, boolean var3);

    protected abstract void writeToClient(InputStream var1, ProtocolSession var2, boolean var3);

    protected abstract void close();
}

