/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.james.core.MailImpl;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.lib.AbstractMailRepository;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.slf4j.Logger;

public class JCRMailRepository
extends AbstractMailRepository
implements MailRepository {
    private static final String MAIL_PATH = "mailrepository";
    private Repository repository;
    private SimpleCredentials creds;
    private String workspace;
    private Logger logger;

    @Inject
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @PostConstruct
    public void init() throws Exception {
        CndImporter.registerNodeTypes((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/apache/james/imap/jcr/james.cnd")), (Session)this.login());
    }

    public void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
        this.workspace = config.getString("workspace", null);
        String username = config.getString("username", null);
        String password = config.getString("password", null);
        if (username != null && password != null) {
            this.creds = new SimpleCredentials(username, password.toCharArray());
        }
    }

    protected String toSafeName(String key) {
        return ISO9075.encode((String)Text.escapeIllegalJcrChars((String)key));
    }

    private Session login() throws RepositoryException {
        return this.repository.login((Credentials)this.creds, this.workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> list() throws MessagingException {
        Iterator<String> iterator;
        Session session = this.login();
        try {
            ArrayList<String> keys = new ArrayList<String>();
            QueryManager manager = session.getWorkspace().getQueryManager();
            Query query = manager.createQuery("/jcr:root/mailrepository//element(*,james:mail)", "xpath");
            NodeIterator iterator2 = query.execute().getNodes();
            while (iterator2.hasNext()) {
                String name = iterator2.nextNode().getName();
                keys.add(Text.unescapeIllegalJcrChars((String)name));
            }
            iterator = keys.iterator();
        }
        catch (Throwable throwable) {
            try {
                session.logout();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new MessagingException("Unable to list messages", (Exception)((Object)e));
            }
        }
        session.logout();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Mail retrieve(String key) throws MessagingException {
        try {
            Session session = this.login();
            try {
                String name = this.toSafeName(key);
                QueryManager manager = session.getWorkspace().getQueryManager();
                Query query = manager.createQuery("/jcr:root/mailrepository//element(" + name + ",james:mail)", "xpath");
                NodeIterator iterator = query.execute().getNodes();
                if (iterator.hasNext()) {
                    Mail mail = this.getMail(iterator.nextNode());
                    return mail;
                }
                Mail mail = null;
                return mail;
            }
            finally {
                session.logout();
            }
        }
        catch (IOException e) {
            throw new MessagingException("Unable to retrieve message: " + key, (Exception)e);
        }
        catch (RepositoryException e) {
            throw new MessagingException("Unable to retrieve message: " + key, (Exception)((Object)e));
        }
    }

    private Mail getMail(Node node) throws MessagingException, RepositoryException, IOException {
        String name = Text.unescapeIllegalJcrChars((String)node.getName());
        MailImpl mail = new MailImpl(name, this.getSender(node), this.getRecipients(node), this.getMessage(node));
        mail.setState(this.getState(node));
        mail.setLastUpdated(this.getLastUpdated(node));
        mail.setErrorMessage(this.getError(node));
        mail.setRemoteHost(this.getRemoteHost(node));
        mail.setRemoteAddr(this.getRemoteAddr(node));
        this.getAttributes(node, (Mail)mail);
        return mail;
    }

    private void setMail(Node node, Mail mail) throws MessagingException, RepositoryException, IOException {
        this.setState(node, mail.getState());
        this.setLastUpdated(node, mail.getLastUpdated());
        this.setError(node, mail.getErrorMessage());
        this.setRemoteHost(node, mail.getRemoteHost());
        this.setRemoteAddr(node, mail.getRemoteAddr());
        this.setSender(node, mail.getSender());
        this.setRecipients(node, mail.getRecipients());
        this.setMessage(node, mail.getMessage());
        this.setAttributes(node, mail);
    }

    private String getState(Node node) throws RepositoryException {
        try {
            return node.getProperty("james:state").getString();
        }
        catch (PathNotFoundException e) {
            return "root";
        }
    }

    private void setState(Node node, String state) throws RepositoryException {
        node.setProperty("james:state", state);
    }

    private Date getLastUpdated(Node node) throws RepositoryException {
        try {
            node = node.getNode("jcr:content");
        }
        catch (PathNotFoundException e) {
            node = node.getProperty("jcr:content").getNode();
        }
        return node.getProperty("jcr:lastModified").getDate().getTime();
    }

    private void setLastUpdated(Node node, Date updated) throws RepositoryException {
        try {
            node = node.getNode("jcr:content");
        }
        catch (PathNotFoundException e) {
            node = node.getProperty("jcr:content").getNode();
        }
        Calendar calendar = Calendar.getInstance();
        if (updated != null) {
            calendar.setTime(updated);
        }
        node.setProperty("jcr:lastModified", calendar);
    }

    private String getError(Node node) throws RepositoryException {
        try {
            return node.getProperty("james:error").getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private void setError(Node node, String error) throws RepositoryException {
        node.setProperty("james:error", error);
    }

    private String getRemoteHost(Node node) throws RepositoryException {
        try {
            return node.getProperty("james:remotehost").getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private void setRemoteHost(Node node, String host) throws RepositoryException {
        node.setProperty("james:remotehost", host);
    }

    private String getRemoteAddr(Node node) throws RepositoryException {
        try {
            return node.getProperty("james:remoteaddr").getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private void setRemoteAddr(Node node, String addr) throws RepositoryException {
        node.setProperty("james:remoteaddr", addr);
    }

    private MailAddress getSender(Node node) throws MessagingException, RepositoryException {
        try {
            String sender = node.getProperty("james:sender").getString();
            return new MailAddress(sender);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private void setSender(Node node, MailAddress sender) throws RepositoryException {
        node.setProperty("james:sender", sender.toString());
    }

    private Collection<MailAddress> getRecipients(Node node) throws MessagingException, RepositoryException {
        try {
            Value[] values = node.getProperty("james:recipients").getValues();
            ArrayList<MailAddress> recipients = new ArrayList<MailAddress>(values.length);
            for (Value value : values) {
                recipients.add(new MailAddress(value.getString()));
            }
            return recipients;
        }
        catch (PathNotFoundException e) {
            return Collections.EMPTY_LIST;
        }
    }

    private void setRecipients(Node node, Collection<MailAddress> recipients) throws RepositoryException {
        String[] values = new String[recipients.size()];
        Iterator<MailAddress> iterator = recipients.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            values[i] = iterator.next().toString();
            ++i;
        }
        node.setProperty("james:recipients", values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeMessage getMessage(Node node) throws MessagingException, RepositoryException, IOException {
        try {
            node = node.getNode("jcr:content");
        }
        catch (PathNotFoundException e) {
            node = node.getProperty("jcr:content").getNode();
        }
        InputStream stream = node.getProperty("jcr:data").getStream();
        try {
            Properties properties = System.getProperties();
            MimeMessage mimeMessage = new MimeMessage(javax.mail.Session.getDefaultInstance((Properties)properties), stream);
            return mimeMessage;
        }
        finally {
            stream.close();
        }
    }

    private void setMessage(Node node, final MimeMessage message) throws RepositoryException, IOException {
        try {
            node = node.getNode("jcr:content");
        }
        catch (PathNotFoundException e) {
            node = node.getProperty("jcr:content").getNode();
        }
        PipedInputStream input = new PipedInputStream();
        final PipedOutputStream output = new PipedOutputStream(input);
        new Thread(){

            @Override
            public void run() {
                try {
                    message.writeTo((OutputStream)output);
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
        node.setProperty("jcr:data", (InputStream)input);
    }

    private void getAttributes(Node node, Mail mail) throws RepositoryException, IOException {
        PropertyIterator iterator = node.getProperties("jamesattr:*");
        while (iterator.hasNext()) {
            Property property = iterator.nextProperty();
            String name = Text.unescapeIllegalJcrChars((String)property.getName().substring("jamesattr:".length()));
            if (property.getType() == 2) {
                InputStream input = property.getStream();
                try {
                    ObjectInputStream stream = new ObjectInputStream(input);
                    mail.setAttribute(name, (Serializable)stream.readObject());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e.getMessage());
                }
                finally {
                    input.close();
                    continue;
                }
            }
            mail.setAttribute(name, (Serializable)((Object)property.getString()));
        }
    }

    private void setAttributes(Node node, Mail mail) throws RepositoryException, IOException {
        Iterator iterator = mail.getAttributeNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            Serializable value = mail.getAttribute(name);
            name = "jamesattr:" + Text.escapeIllegalJcrChars((String)name);
            if (value instanceof String || value == null) {
                node.setProperty(name, (String)((Object)value));
                continue;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(buffer);
            output.writeObject(value);
            output.close();
            node.setProperty(name, (InputStream)new ByteArrayInputStream(buffer.toByteArray()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRemove(String key) throws MessagingException {
        try {
            Session session = this.login();
            try {
                String name = ISO9075.encode((String)Text.escapeIllegalJcrChars((String)key));
                QueryManager manager = session.getWorkspace().getQueryManager();
                Query query = manager.createQuery("/jcr:root/mailrepository//element(" + name + ",james:mail)", "xpath");
                NodeIterator nodes = query.execute().getNodes();
                if (nodes.hasNext()) {
                    while (nodes.hasNext()) {
                        nodes.nextNode().remove();
                    }
                    session.save();
                    this.logger.info("Mail " + key + " removed from repository");
                } else {
                    this.logger.warn("Mail " + key + " not found");
                }
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            throw new MessagingException("Unable to remove message: " + key, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStore(Mail mail) throws MessagingException, IOException {
        try {
            Session session = this.login();
            try {
                String name = Text.escapeIllegalJcrChars((String)mail.getName());
                String xpath = "/jcr:root/mailrepository//element(" + name + ",james:mail)";
                QueryManager manager = session.getWorkspace().getQueryManager();
                Query query = manager.createQuery(xpath, "xpath");
                NodeIterator iterator = query.execute().getNodes();
                if (iterator.hasNext()) {
                    while (iterator.hasNext()) {
                        this.setMail(iterator.nextNode(), mail);
                    }
                } else {
                    Node parent = session.getRootNode().getNode(MAIL_PATH);
                    Node node = parent.addNode(name, "james:mail");
                    Node resource = node.addNode("jcr:content", "nt:resource");
                    resource.setProperty("jcr:mimeType", "message/rfc822");
                    this.setMail(node, mail);
                }
                session.save();
                this.logger.info("Mail " + mail.getName() + " stored in repository");
            }
            finally {
                session.logout();
            }
        }
        catch (IOException e) {
            throw new MessagingException("Unable to store message: " + mail.getName(), (Exception)e);
        }
        catch (RepositoryException e) {
            throw new MessagingException("Unable to store message: " + mail.getName(), (Exception)((Object)e));
        }
    }
}

