/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.file;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.file.FileMailQueue;
import org.slf4j.Logger;

public class FileMailQueueFactory
implements MailQueueFactory,
LogEnabled {
    private final Map<String, MailQueue> queues = new HashMap<String, MailQueue>();
    private MailQueueItemDecoratorFactory mailQueueActionItemDecoratorFactory;
    private FileSystem fs;
    private Logger log;
    private boolean sync = true;

    @Inject
    public FileMailQueueFactory(FileSystem fs, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory) {
        this.fs = fs;
        this.mailQueueActionItemDecoratorFactory = mailQueueItemDecoratorFactory;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailQueue getQueue(String name) {
        Object queue = this.queues.get(name);
        if (queue == null) {
            Map<String, MailQueue> map = this.queues;
            synchronized (map) {
                try {
                    queue = new FileMailQueue(this.mailQueueActionItemDecoratorFactory, this.fs.getFile("file://var/store/queue"), name, this.sync, this.log);
                    this.queues.put(name, (MailQueue)queue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to access queue " + name, e);
                }
            }
        }
        return queue;
    }

    public void setLog(Logger log) {
        this.log = log;
    }
}

