/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;

public class FileMailQueue
implements ManageableMailQueue {
    private final ConcurrentHashMap<String, FileItem> keyMappings = new ConcurrentHashMap();
    private final BlockingQueue<String> inmemoryQueue = new LinkedBlockingQueue<String>();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final AtomicLong COUNTER = new AtomicLong();
    private final String queueDirName;
    private final File queueDir;
    private final Logger log;
    private final MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory;
    private final boolean sync;
    private static final String MSG_EXTENSION = ".msg";
    private static final String OBJECT_EXTENSION = ".obj";
    private static final String NEXT_DELIVERY = "FileQueueNextDelivery";
    private static final int SPLITCOUNT = 10;

    public FileMailQueue(MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, File parentDir, String queuename, boolean sync, Logger log) throws IOException {
        this.mailQueueItemDecoratorFactory = mailQueueItemDecoratorFactory;
        this.log = log;
        this.sync = sync;
        this.queueDir = new File(parentDir, queuename);
        this.queueDirName = this.queueDir.getAbsolutePath();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        for (int i = 1; i <= 10; ++i) {
            String[] files;
            File qDir = new File(this.queueDir, Integer.toString(i));
            FileUtils.forceMkdir((File)qDir);
            for (String name : files = qDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(FileMailQueue.OBJECT_EXTENSION);
                }
            })) {
                ObjectInputStream oin = null;
                try {
                    String msgFileName = name.substring(0, name.length() - OBJECT_EXTENSION.length()) + MSG_EXTENSION;
                    FileItem item = new FileItem(qDir.getAbsolutePath() + File.separator + name, qDir.getAbsolutePath() + File.separator + msgFileName);
                    oin = new ObjectInputStream(new FileInputStream(item.getObjectFile()));
                    Mail mail = (Mail)oin.readObject();
                    Long next = (Long)mail.getAttribute(NEXT_DELIVERY);
                    if (next == null) {
                        next = 0L;
                    }
                    final String key = mail.getName();
                    this.keyMappings.put(key, item);
                    if (next <= System.currentTimeMillis()) {
                        try {
                            this.inmemoryQueue.put(key);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Unable to init", e);
                        }
                    }
                    this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                FileMailQueue.this.inmemoryQueue.put(key);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new RuntimeException("Unable to init", e);
                            }
                        }
                    }, next - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                }
                catch (ClassNotFoundException e1) {
                    this.log.error("Unable to load Mail", (Throwable)e1);
                }
                catch (IOException e) {
                    this.log.error("Unable to load Mail", (Throwable)e);
                }
                finally {
                    if (oin != null) {
                        try {
                            oin.close();
                        }
                        catch (Exception e1) {}
                    }
                }
            }
        }
    }

    public void enQueue(Mail mail, long delay, TimeUnit unit) throws MailQueue.MailQueueException {
        final String key = mail.getName() + "-" + COUNTER.incrementAndGet();
        FileOutputStream out = null;
        FileOutputStream foout = null;
        ObjectOutputStream oout = null;
        try {
            int i = (int)(Math.random() * 10.0 + 1.0);
            String name = this.queueDirName + "/" + i + "/" + key;
            FileItem item = new FileItem(name + OBJECT_EXTENSION, name + MSG_EXTENSION);
            if (delay > 0L) {
                mail.setAttribute(NEXT_DELIVERY, (Serializable)Long.valueOf(System.currentTimeMillis() + unit.toMillis(delay)));
            }
            foout = new FileOutputStream(item.getObjectFile());
            oout = new ObjectOutputStream(foout);
            oout.writeObject(mail);
            oout.flush();
            if (this.sync) {
                foout.getFD().sync();
            }
            out = new FileOutputStream(item.getMessageFile());
            mail.getMessage().writeTo((OutputStream)out);
            out.flush();
            if (this.sync) {
                out.getFD().sync();
            }
            this.keyMappings.put(key, item);
            if (delay > 0L) {
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileMailQueue.this.inmemoryQueue.put(key);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Unable to init", e);
                        }
                    }
                }, delay, unit);
            } else {
                this.inmemoryQueue.put(key);
            }
        }
        catch (FileNotFoundException e) {
            throw new MailQueue.MailQueueException("Unable to enqueue mail", (Exception)e);
        }
        catch (IOException e) {
            throw new MailQueue.MailQueueException("Unable to enqueue mail", (Exception)e);
        }
        catch (MessagingException e) {
            throw new MailQueue.MailQueueException("Unable to enqueue mail", (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            throw new MailQueue.MailQueueException("Unable to enqueue mail", (Exception)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException iOException) {}
            }
            if (foout != null) {
                try {
                    foout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void enQueue(Mail mail) throws MailQueue.MailQueueException {
        this.enQueue(mail, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MailQueue.MailQueueItem deQueue() throws MailQueue.MailQueueException {
        try {
            FileItem item = null;
            String k = null;
            while (item == null) {
                k = this.inmemoryQueue.take();
                item = this.keyMappings.get(k);
            }
            final String key = k;
            final FileItem fitem = item;
            ObjectInputStream oin = null;
            try {
                File objectFile = new File(fitem.getObjectFile());
                File msgFile = new File(fitem.getMessageFile());
                oin = new ObjectInputStream(new FileInputStream(objectFile));
                final Mail mail = (Mail)oin.readObject();
                mail.setMessage((MimeMessage)new MimeMessageCopyOnWriteProxy((MimeMessageSource)new FileMimeMessageSource(msgFile)));
                MailQueue.MailQueueItem fileMailQueueItem = new MailQueue.MailQueueItem(){

                    public Mail getMail() {
                        return mail;
                    }

                    public void done(boolean success) throws MailQueue.MailQueueException {
                        if (!success) {
                            try {
                                FileMailQueue.this.inmemoryQueue.put(key);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new MailQueue.MailQueueException("Unable to rollback", (Exception)e);
                            }
                        } else {
                            fitem.delete();
                            FileMailQueue.this.keyMappings.remove(key);
                        }
                        LifecycleUtil.dispose((Object)mail);
                    }
                };
                MailQueueItemDecoratorFactory.MailQueueItemDecorator mailQueueItemDecorator = this.mailQueueItemDecoratorFactory.decorate(fileMailQueueItem);
                return mailQueueItemDecorator;
            }
            catch (FileNotFoundException e) {
                throw new MailQueue.MailQueueException("Unable to dequeue", (Exception)e);
            }
            catch (IOException e) {
                throw new MailQueue.MailQueueException("Unable to dequeue", (Exception)e);
            }
            catch (ClassNotFoundException e) {
                throw new MailQueue.MailQueueException("Unable to dequeue", (Exception)e);
            }
            catch (MessagingException e) {
                throw new MailQueue.MailQueueException("Unable to dequeue", (Exception)((Object)e));
            }
            finally {
                if (oin != null) {
                    try {
                        oin.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MailQueue.MailQueueException("Unable to dequeue", (Exception)e);
        }
    }

    public long getSize() throws MailQueue.MailQueueException {
        return this.keyMappings.size();
    }

    public long flush() throws MailQueue.MailQueueException {
        Iterator keys = ((ConcurrentHashMap.KeySetView)this.keyMappings.keySet()).iterator();
        long i = 0L;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (this.inmemoryQueue.contains(key)) continue;
            this.inmemoryQueue.add(key);
            ++i;
        }
        return i;
    }

    public long clear() throws MailQueue.MailQueueException {
        Iterator<Map.Entry<String, FileItem>> items = this.keyMappings.entrySet().iterator();
        long count = 0L;
        while (items.hasNext()) {
            Map.Entry<String, FileItem> entry = items.next();
            FileItem item = entry.getValue();
            String key = entry.getKey();
            item.delete();
            this.keyMappings.remove(key);
            ++count;
        }
        return count;
    }

    public long remove(ManageableMailQueue.Type type, String value) throws MailQueue.MailQueueException {
        switch (type) {
            case Name: {
                FileItem item = this.keyMappings.remove(value);
                if (item != null) {
                    item.delete();
                    return 1L;
                }
                return 0L;
            }
        }
        throw new MailQueue.MailQueueException("Not supported yet");
    }

    public ManageableMailQueue.MailQueueIterator browse() throws MailQueue.MailQueueException {
        final Iterator<FileItem> items = this.keyMappings.values().iterator();
        return new ManageableMailQueue.MailQueueIterator(){
            private ManageableMailQueue.MailQueueItemView item = null;

            public void remove() {
                throw new UnsupportedOperationException("Read-only");
            }

            public ManageableMailQueue.MailQueueItemView next() {
                if (this.hasNext()) {
                    ManageableMailQueue.MailQueueItemView vitem = this.item;
                    this.item = null;
                    return vitem;
                }
                throw new NoSuchElementException();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                if (this.item == null) {
                    while (items.hasNext()) {
                        ObjectInputStream in = null;
                        try {
                            in = new ObjectInputStream(new FileInputStream(((FileItem)items.next()).getObjectFile()));
                            final Mail mail = (Mail)in.readObject();
                            this.item = new ManageableMailQueue.MailQueueItemView(){

                                public long getNextDelivery() {
                                    return (Long)mail.getAttribute(FileMailQueue.NEXT_DELIVERY);
                                }

                                public Mail getMail() {
                                    return mail;
                                }
                            };
                            boolean bl = true;
                            return bl;
                        }
                        catch (FileNotFoundException e) {
                            FileMailQueue.this.log.info("Unable to load mail", (Throwable)e);
                        }
                        catch (IOException e) {
                            FileMailQueue.this.log.info("Unable to load mail", (Throwable)e);
                        }
                        catch (ClassNotFoundException e) {
                            FileMailQueue.this.log.info("Unable to load mail", (Throwable)e);
                        }
                        finally {
                            if (in == null) continue;
                            try {
                                in.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    return false;
                }
                return true;
            }

            public void close() {
            }
        };
    }

    private final class FileItem {
        private final String objectfile;
        private final String messagefile;

        public FileItem(String objectfile, String messagefile) {
            this.objectfile = objectfile;
            this.messagefile = messagefile;
        }

        public String getObjectFile() {
            return this.objectfile;
        }

        public String getMessageFile() {
            return this.messagefile;
        }

        public void delete() throws MailQueue.MailQueueException {
            try {
                FileUtils.forceDelete((File)new File(this.getObjectFile()));
            }
            catch (IOException e) {
                throw new MailQueue.MailQueueException("Unable to delete mail");
            }
            try {
                FileUtils.forceDelete((File)new File(this.getMessageFile()));
            }
            catch (IOException e) {
                FileMailQueue.this.log.debug("Remove of msg file for mail failed");
            }
        }
    }

    private final class FileMimeMessageSource
    extends MimeMessageSource
    implements Disposable {
        private File file;
        private final SharedFileInputStream in;

        public FileMimeMessageSource(File file) throws IOException {
            this.file = file;
            this.in = new SharedFileInputStream(file);
        }

        public String getSourceId() {
            return this.file.getAbsolutePath();
        }

        public InputStream getInputStream() throws IOException {
            return this.in.newStream(0L, -1L);
        }

        public long getMessageSize() throws IOException {
            return this.file.length();
        }

        public void dispose() {
            IOUtils.closeQuietly((InputStream)this.in);
            this.file = null;
        }
    }
}

