/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jpa;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.jpa.model.JPAUser;
import org.apache.james.user.lib.AbstractUsersRepository;

public class JPAUsersRepository
extends AbstractUsersRepository {
    private EntityManagerFactory entityManagerFactory;
    private String algo;

    @Inject
    @PersistenceUnit(unitName="James")
    public final void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @PostConstruct
    public void init() {
        this.createEntityManager().close();
    }

    public User getUserByName(String name) throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            JPAUser jPAUser = (JPAUser)entityManager.createNamedQuery("findUserByName").setParameter("name", (Object)name).getSingleResult();
            return jPAUser;
        }
        catch (NoResultException e) {
            User user = null;
            return user;
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to find user", (Throwable)e);
            throw new UsersRepositoryException("Unable to search user", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public String getRealName(String name) throws UsersRepositoryException {
        User u = this.getUserByName(name);
        if (u != null) {
            u.getUserName();
        }
        return null;
    }

    public void updateUser(User user) throws UsersRepositoryException {
        block7: {
            EntityManager entityManager = this.entityManagerFactory.createEntityManager();
            EntityTransaction transaction = entityManager.getTransaction();
            try {
                if (this.contains(user.getUserName())) {
                    transaction.begin();
                    entityManager.merge((Object)user);
                    transaction.commit();
                    break block7;
                }
                this.getLogger().debug("User not found");
                throw new UsersRepositoryException("User " + user.getUserName() + " not found");
            }
            catch (PersistenceException e) {
                this.getLogger().debug("Failed to update user", (Throwable)e);
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                throw new UsersRepositoryException("Failed to update user " + user.getUserName(), (Throwable)e);
            }
            finally {
                entityManager.close();
            }
        }
    }

    public void removeUser(String name) throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            if (entityManager.createNamedQuery("deleteUserByName").setParameter("name", (Object)name).executeUpdate() < 1) {
                transaction.commit();
                throw new UsersRepositoryException("User " + name + " does not exist");
            }
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to remove user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new UsersRepositoryException("Failed to remove user " + name, (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public boolean contains(String name) throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            boolean bl = (Long)entityManager.createNamedQuery("containsUser").setParameter("name", (Object)name.toLowerCase(Locale.US)).getSingleResult() > 0L;
            return bl;
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to find user", (Throwable)e);
            throw new UsersRepositoryException("Failed to find user" + name, (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        User user = this.getUserByName(name);
        boolean result = user != null && user.verifyPassword(password);
        return result;
    }

    public int countUsers() throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            int n = ((Long)entityManager.createNamedQuery("countUsers").getSingleResult()).intValue();
            return n;
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to find user", (Throwable)e);
            throw new UsersRepositoryException("Failed to count users", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public Iterator<String> list() throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            Iterator<String> iterator = Collections.unmodifiableList(entityManager.createNamedQuery("listUserNames").getResultList()).iterator();
            return iterator;
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to find user", (Throwable)e);
            throw new UsersRepositoryException("Failed to list users", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
        this.algo = config.getString("algorithm", "MD5");
        super.doConfigure(config);
    }

    private EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    protected void doAddUser(String username, String password) throws UsersRepositoryException {
        String lowerCasedUsername = username.toLowerCase(Locale.US);
        if (this.contains(lowerCasedUsername)) {
            throw new UsersRepositoryException(lowerCasedUsername + " already exists.");
        }
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            JPAUser user = new JPAUser(lowerCasedUsername, password, this.algo);
            entityManager.persist((Object)user);
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to save user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new UsersRepositoryException("Failed to add user" + username, (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }
}

