/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.jpa.model.JPARecipientRewrite;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;

public class JPARecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private EntityManagerFactory entityManagerFactory;

    @Inject
    @PersistenceUnit(unitName="James")
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    protected void addMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        String fixedDomain;
        String fixedUser = this.getFixedUser(user);
        Mappings map = this.getUserDomainMappings(fixedUser, fixedDomain = this.getFixedDomain(domain));
        if (map != null && map.size() != 0) {
            MappingsImpl updatedMappings = MappingsImpl.from((Mappings)map).add(mapping).build();
            this.doUpdateMapping(fixedUser, fixedDomain, updatedMappings.serialize());
        } else {
            this.doAddMapping(fixedUser, fixedDomain, mapping);
        }
    }

    protected String mapAddressInternal(String user, String domain) throws RecipientRewriteTableException {
        String mapping = this.getMapping(user, domain, "selectExactMappings");
        if (mapping != null) {
            return mapping;
        }
        return this.getMapping(user, domain, "selectMappings");
    }

    private String getMapping(String user, String domain, String queryName) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            List virtualUsers = entityManager.createNamedQuery(queryName).setParameter("user", (Object)user).setParameter("domain", (Object)domain).getResultList();
            transaction.commit();
            if (virtualUsers.size() > 0) {
                String string = ((JPARecipientRewrite)virtualUsers.get(0)).getTargetAddress();
                return string;
            }
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to find mapping for  user=" + user + " and domain=" + domain, (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Error while retrieve mappings", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
        return null;
    }

    protected Mappings getUserDomainMappingsInternal(String user, String domain) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            List virtualUsers = entityManager.createNamedQuery("selectUserDomainMapping").setParameter("user", (Object)user).setParameter("domain", (Object)domain).getResultList();
            transaction.commit();
            if (virtualUsers.size() > 0) {
                MappingsImpl mappingsImpl = MappingsImpl.fromRawString((String)((JPARecipientRewrite)virtualUsers.get(0)).getTargetAddress());
                return mappingsImpl;
            }
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to get user domain mappings", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Error while retrieve mappings", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
        return null;
    }

    protected Map<String, Mappings> getAllMappingsInternal() throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        HashMap<String, MappingsImpl> mapping = new HashMap<String, MappingsImpl>();
        try {
            transaction.begin();
            List virtualUsers = entityManager.createNamedQuery("selectAllMappings").getResultList();
            transaction.commit();
            for (JPARecipientRewrite virtualUser : virtualUsers) {
                mapping.put(virtualUser.getUser() + "@" + virtualUser.getDomain(), MappingsImpl.fromRawString((String)virtualUser.getTargetAddress()));
            }
            if (mapping.size() > 0) {
                HashMap<String, MappingsImpl> hashMap = mapping;
                return hashMap;
            }
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to get all mappings", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Error while retrieve mappings", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
        return null;
    }

    protected void removeMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        String fixedDomain;
        String fixedUser = this.getFixedUser(user);
        Mappings map = this.getUserDomainMappings(fixedUser, fixedDomain = this.getFixedDomain(domain));
        if (map != null && map.size() > 1) {
            Mappings updatedMappings = map.remove(mapping);
            this.doUpdateMapping(fixedUser, fixedDomain, updatedMappings.serialize());
        } else {
            this.doRemoveMapping(fixedUser, fixedDomain, mapping);
        }
    }

    private boolean doUpdateMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            int updated = entityManager.createNamedQuery("updateMapping").setParameter("targetAddress", (Object)mapping).setParameter("user", (Object)user).setParameter("domain", (Object)domain).executeUpdate();
            transaction.commit();
            if (updated > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to update mapping", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Unable to update mapping", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
        return false;
    }

    private void doRemoveMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            entityManager.createNamedQuery("deleteMapping").setParameter("user", (Object)user).setParameter("domain", (Object)domain).setParameter("targetAddress", (Object)mapping).executeUpdate();
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to remove mapping", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Unable to remove mapping", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    private void doAddMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            JPARecipientRewrite jpaRecipientRewrite = new JPARecipientRewrite(user, domain, mapping);
            entityManager.persist((Object)jpaRecipientRewrite);
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().debug("Failed to save virtual user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Unable to add mapping", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }
}

