/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.jpa;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.jpa.model.JPADomain;
import org.apache.james.domainlist.lib.AbstractDomainList;

public class JPADomainList
extends AbstractDomainList {
    private EntityManagerFactory entityManagerFactory;

    @Inject
    @PersistenceUnit(unitName="James")
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @PostConstruct
    public void init() {
        this.createEntityManager().close();
    }

    protected List<String> getDomainListInternal() throws DomainListException {
        List domains = new ArrayList();
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            domains = entityManager.createNamedQuery("listDomainNames").getResultList();
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().error("Failed to list domains", (Throwable)e);
            this.rollback(transaction);
            throw new DomainListException("Unable to retrieve domains", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
        return ImmutableList.copyOf(domains);
    }

    public boolean containsDomain(String domain) throws DomainListException {
        String lowerCasedDomain = domain.toLowerCase(Locale.US);
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            boolean result = this.containsDomainInternal(lowerCasedDomain, entityManager);
            transaction.commit();
            boolean bl = result;
            return bl;
        }
        catch (PersistenceException e) {
            this.getLogger().error("Failed to find domain", (Throwable)e);
            this.rollback(transaction);
            throw new DomainListException("Unable to retrieve domains", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public void addDomain(String domain) throws DomainListException {
        String lowerCasedDomain = domain.toLowerCase(Locale.US);
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            if (this.containsDomainInternal(lowerCasedDomain, entityManager)) {
                transaction.commit();
                throw new DomainListException(lowerCasedDomain + " already exists.");
            }
            JPADomain jpaDomain = new JPADomain(lowerCasedDomain);
            entityManager.persist((Object)jpaDomain);
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().error("Failed to save domain", (Throwable)e);
            this.rollback(transaction);
            throw new DomainListException("Unable to add domain " + domain, (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public void removeDomain(String domain) throws DomainListException {
        String lowerCasedDomain = domain.toLowerCase(Locale.US);
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            if (!this.containsDomainInternal(lowerCasedDomain, entityManager)) {
                transaction.commit();
                throw new DomainListException(domain + " was not found.");
            }
            entityManager.createNamedQuery("deleteDomainByName").setParameter("name", (Object)lowerCasedDomain).executeUpdate();
            transaction.commit();
        }
        catch (PersistenceException e) {
            this.getLogger().error("Failed to remove domain", (Throwable)e);
            this.rollback(transaction);
            throw new DomainListException("Unable to remove domain " + domain, (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    private void rollback(EntityTransaction transaction) {
        if (transaction.isActive()) {
            transaction.rollback();
        }
    }

    private boolean containsDomainInternal(String domain, EntityManager entityManager) {
        try {
            return entityManager.createNamedQuery("findDomainByName").setParameter("name", (Object)domain).getSingleResult() != null;
        }
        catch (NoResultException e) {
            this.getLogger().debug("No domain found", (Throwable)e);
            return false;
        }
    }

    private EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }
}

