/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver.hook;

import java.io.IOException;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.protocols.lib.Slf4jLoggerAdapter;
import org.apache.james.protocols.lmtp.hook.DeliverToRecipientHook;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.slf4j.Logger;

public class MailboxDeliverToRecipientHandler
implements DeliverToRecipientHook {
    private UsersRepository users;
    private MailboxManager mailboxManager;

    @Inject
    public final void setUsersRepository(UsersRepository users) {
        this.users = users;
    }

    @Inject
    public final void setMailboxManager(@Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public HookResult deliver(SMTPSession session, MailAddress recipient, MailEnvelope envelope) {
        HookResult result;
        try {
            String username = this.users.supportVirtualHosting() ? recipient.toString() : recipient.getLocalPart();
            MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username, (Logger)new Slf4jLoggerAdapter(session.getLogger()));
            MailboxPath inbox = MailboxPath.inbox((MailboxSession)mailboxSession);
            this.mailboxManager.startProcessingRequest(mailboxSession);
            if (!this.mailboxManager.mailboxExists(inbox, mailboxSession)) {
                this.mailboxManager.createMailbox(inbox, mailboxSession);
            }
            this.mailboxManager.getMailbox(MailboxPath.inbox((MailboxSession)mailboxSession), mailboxSession).appendMessage(envelope.getMessageInputStream(), new Date(), mailboxSession, true, null);
            this.mailboxManager.endProcessingRequest(mailboxSession);
            result = new HookResult(1, "250", (CharSequence)(DSNStatus.getStatus((int)2, (String)"6.0") + " Message received"));
        }
        catch (IOException e) {
            session.getLogger().info("Unexpected error handling DATA stream", (Throwable)e);
            result = new HookResult(4, " Temporary error deliver message to " + recipient);
        }
        catch (MailboxException e) {
            session.getLogger().info("Unexpected error handling DATA stream", (Throwable)e);
            result = new HookResult(4, " Temporary error deliver message to " + recipient);
        }
        catch (UsersRepositoryException e) {
            session.getLogger().info("Unexpected error handling DATA stream", (Throwable)e);
            result = new HookResult(4, " Temporary error deliver message to " + recipient);
        }
        return result;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }
}

