/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.mail;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.mailet.base.mail.AbstractDataContentHandler;

public class message_disposition_notification
extends AbstractDataContentHandler {
    @Override
    protected ActivationDataFlavor computeDataFlavor() {
        return new ActivationDataFlavor(String.class, "message/disposition-notification", "Message String");
    }

    @Override
    protected Object computeContent(DataSource aDataSource) throws MessagingException {
        String encoding = this.getCharacterSet(aDataSource.getContentType());
        Reader reader = null;
        StringWriter writer = new StringWriter(2048);
        String content = null;
        try {
            reader = new BufferedReader(new InputStreamReader(aDataSource.getInputStream(), encoding), 2048);
            while (reader.ready()) {
                ((Writer)writer).write(reader.read());
            }
            ((Writer)writer).flush();
            content = ((Object)writer).toString();
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException("Encoding = \"" + encoding + "\"", (Exception)e);
        }
        catch (IOException e) {
            throw new MessagingException("Exception obtaining content from DataSource", (Exception)e);
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return content;
    }

    public void writeTo(Object aPart, String aMimeType, OutputStream aStream) throws IOException {
        BufferedWriter writer;
        if (!(aPart instanceof String)) {
            throw new IOException("Type \"" + aPart.getClass().getName() + "\" is not supported.");
        }
        String encoding = this.getCharacterSet(this.getDataFlavor().getMimeType());
        try {
            writer = new BufferedWriter(new OutputStreamWriter(aStream, encoding), 2048);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedEncodingException(encoding);
        }
        writer.write((String)aPart);
        ((Writer)writer).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCharacterSet(String aType) {
        String characterSet = null;
        try {
            characterSet = new ContentType(aType).getParameter("charset");
        }
        catch (ParseException parseException) {
        }
        finally {
            if (null == characterSet) {
                characterSet = "us-ascii";
            }
        }
        return MimeUtility.javaCharset((String)characterSet);
    }
}

