/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;

public class MailetPipelineLogging {
    public static void logBeginOfMailetProcess(final Mailet mailet, final Mail mail) {
        MailetPipelineLogging.getLogger(mailet).transform((Function)new Function<Logger, Boolean>(){

            public Boolean apply(Logger logger) {
                logger.debug("Entering mailet: {}\n\tmail state {}", (Object)mailet.getMailetInfo(), (Object)mail.getState());
                return true;
            }
        });
    }

    public static void logEndOfMailetProcess(final Mailet mailet, final Mail mail) {
        MailetPipelineLogging.getLogger(mailet).transform((Function)new Function<Logger, Boolean>(){

            public Boolean apply(Logger logger) {
                logger.debug("End of mailet: {}\n\tmail state {}", (Object)mailet.getMailetInfo(), (Object)mail.getState());
                return true;
            }
        });
    }

    private static Optional<Logger> getLogger(Mailet mailet) {
        MailetConfig mailetConfig = mailet.getMailetConfig();
        if (mailetConfig == null) {
            return Optional.absent();
        }
        MailetContext mailetContext = mailetConfig.getMailetContext();
        if (mailetContext == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)mailetContext.getLogger());
    }
}

