/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.MailetUtil;
import org.apache.mailet.base.StringUtils;

public abstract class GenericMailet
implements Mailet,
MailetConfig {
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private MailetConfig config = null;

    public void destroy() {
    }

    public boolean getInitParameter(String name, boolean defaultValue) {
        if (this.config == null) {
            throw new NullPointerException("Mailet configuration must be set before getInitParameter is called.");
        }
        return (Boolean)MailetUtil.getInitParameter(this.config, name).or((Object)defaultValue);
    }

    public Optional<String> getInitParameterAsOptional(String name) {
        String value = this.getInitParameter(name);
        if (Strings.isNullOrEmpty((String)value)) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    public boolean getBooleanParameter(String value, boolean defaultValue) {
        if (defaultValue) {
            return !GenericMailet.isFalseOrNo(value);
        }
        return GenericMailet.isTrueOrYes(value);
    }

    private static boolean isFalseOrNo(String value) {
        return org.apache.commons.lang.StringUtils.containsIgnoreCase((String)value, (String)FALSE) || org.apache.commons.lang.StringUtils.containsIgnoreCase((String)value, (String)NO);
    }

    private static boolean isTrueOrYes(String value) {
        return org.apache.commons.lang.StringUtils.containsIgnoreCase((String)value, (String)TRUE) || org.apache.commons.lang.StringUtils.containsIgnoreCase((String)value, (String)YES);
    }

    public String getInitParameter(String name) {
        return this.config.getInitParameter(name);
    }

    public String getInitParameter(String name, String defValue) {
        String res = this.config.getInitParameter(name);
        if (res == null) {
            return defValue;
        }
        return res;
    }

    public Iterator<String> getInitParameterNames() {
        return this.config.getInitParameterNames();
    }

    public MailetConfig getMailetConfig() {
        return this.config;
    }

    public MailetContext getMailetContext() {
        return this.getMailetConfig().getMailetContext();
    }

    public String getMailetInfo() {
        return "";
    }

    public String getMailetName() {
        return this.config.getMailetName();
    }

    public void init(MailetConfig newConfig) throws MessagingException {
        this.config = newConfig;
        this.init();
    }

    public void init() throws MessagingException {
    }

    public void log(String message) {
        this.getMailetContext().log(MailetContext.LogLevel.INFO, message);
    }

    public void log(String message, Throwable t) {
        this.getMailetContext().log(MailetContext.LogLevel.ERROR, message, t);
    }

    public abstract void service(Mail var1) throws MessagingException;

    protected final void checkInitParameters(String[] allowedArray) throws MessagingException {
        if (allowedArray == null) {
            return;
        }
        HashSet allowed = new HashSet();
        ArrayList<String> bad = new ArrayList<String>();
        Collections.addAll(allowed, allowedArray);
        Iterator<String> iterator = this.getInitParameterNames();
        while (iterator.hasNext()) {
            String parameter = iterator.next();
            if (allowed.contains(parameter)) continue;
            bad.add(parameter);
        }
        if (bad.size() > 0) {
            throw new MessagingException("Unexpected init parameters found: " + StringUtils.arrayToString(bad.toArray()));
        }
    }
}

