/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.user;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;

public class InMemorySubscriptionMapper
extends NonTransactionalMapper
implements SubscriptionMapper {
    private static final int INITIAL_SIZE = 64;
    private final Map<String, List<Subscription>> subscriptionsByUser = new ConcurrentHashMap<String, List<Subscription>>(64);

    public synchronized void delete(Subscription subscription) {
        String user = subscription.getUser();
        List<Subscription> subscriptions = this.subscriptionsByUser.get(user);
        if (subscriptions != null) {
            subscriptions.remove(subscription);
        }
    }

    public Subscription findMailboxSubscriptionForUser(String user, String mailbox) {
        List<Subscription> subscriptions = this.subscriptionsByUser.get(user);
        Subscription result = null;
        if (subscriptions != null) {
            for (Subscription subscription : subscriptions) {
                if (!subscription.getMailbox().equals(mailbox)) continue;
                result = subscription;
                break;
            }
        }
        return result;
    }

    public List<Subscription> findSubscriptionsForUser(String user) {
        List<Subscription> subcriptions = this.subscriptionsByUser.get(user);
        ImmutableList results = subcriptions == null ? ImmutableList.of() : ImmutableList.copyOf(subcriptions);
        return results;
    }

    public synchronized void save(Subscription subscription) {
        String user = subscription.getUser();
        List<Subscription> subscriptions = this.subscriptionsByUser.get(user);
        if (subscriptions == null) {
            ArrayList<Subscription> newSubscriptions = new ArrayList<Subscription>();
            newSubscriptions.add(subscription);
            this.subscriptionsByUser.put(user, newSubscriptions);
        } else {
            subscriptions.add(subscription);
        }
    }

    public void deleteAll() {
        this.subscriptionsByUser.clear();
    }

    public void endRequest() {
    }
}

