/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.quota;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;

public class InMemoryPerUserMaxQuotaManager
implements MaxQuotaManager {
    private long maxMessage = -1L;
    private long maxStorage = -1L;
    private final Map<String, Long> userMaxStorage = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> userMaxMessage = new ConcurrentHashMap<String, Long>();

    public void setDefaultMaxStorage(long maxStorage) throws MailboxException {
        this.maxStorage = maxStorage;
    }

    public void setDefaultMaxMessage(long maxMessage) throws MailboxException {
        this.maxMessage = maxMessage;
    }

    public long getMaxStorage(QuotaRoot quotaRoot) throws MailboxException {
        Long max = this.userMaxStorage.get(quotaRoot.getValue());
        if (max == null) {
            return this.maxStorage;
        }
        return max;
    }

    public long getMaxMessage(QuotaRoot quotaRoot) throws MailboxException {
        Long max = this.userMaxMessage.get(quotaRoot.getValue());
        if (max == null) {
            return this.maxMessage;
        }
        return max;
    }

    public void setMaxStorage(QuotaRoot user, long maxStorageQuota) {
        this.userMaxStorage.put(user.getValue(), maxStorageQuota);
    }

    public void setMaxMessage(QuotaRoot quotaRoot, long maxMessageCount) {
        this.userMaxMessage.put(quotaRoot.getValue(), maxMessageCount);
    }

    public long getDefaultMaxStorage() throws MailboxException {
        return this.maxStorage;
    }

    public long getDefaultMaxMessage() throws MailboxException {
        return this.maxMessage;
    }
}

