/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.mail.AbstractMessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.mail.utils.ApplicableFlagCalculator;

public class InMemoryMessageMapper
extends AbstractMessageMapper {
    private final Map<InMemoryId, Map<MessageUid, MailboxMessage>> mailboxByUid = new ConcurrentHashMap<InMemoryId, Map<MessageUid, MailboxMessage>>(256);
    private static final int INITIAL_SIZE = 256;

    public InMemoryMessageMapper(MailboxSession session, UidProvider uidProvider, ModSeqProvider modSeqProvider) {
        super(session, uidProvider, modSeqProvider);
    }

    private Map<MessageUid, MailboxMessage> getMembershipByUidForMailbox(Mailbox mailbox) {
        return this.getMembershipByUidForId((InMemoryId)mailbox.getMailboxId());
    }

    private Map<MessageUid, MailboxMessage> getMembershipByUidForId(InMemoryId id) {
        Map<MessageUid, MailboxMessage> membershipByUid = this.mailboxByUid.get(id);
        if (membershipByUid == null) {
            membershipByUid = new ConcurrentHashMap<MessageUid, MailboxMessage>(256);
            this.mailboxByUid.put(id, membershipByUid);
        }
        return membershipByUid;
    }

    public long countMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        return this.getMembershipByUidForMailbox(mailbox).size();
    }

    public long countUnseenMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        long count = 0L;
        for (MailboxMessage member : this.getMembershipByUidForMailbox(mailbox).values()) {
            if (member.isSeen()) continue;
            ++count;
        }
        return count;
    }

    public void delete(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        this.getMembershipByUidForMailbox(mailbox).remove(message.getUid());
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        InMemoryId originalMailboxId = (InMemoryId)original.getMailboxId();
        MessageUid uid = original.getUid();
        MessageMetaData messageMetaData = this.copy(mailbox, original);
        this.getMembershipByUidForId(originalMailboxId).remove(uid);
        return messageMetaData;
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType ftype, int max) throws MailboxException {
        List<Object> results = new ArrayList<MailboxMessage>(this.getMembershipByUidForMailbox(mailbox).values());
        Iterator it = results.iterator();
        while (it.hasNext()) {
            if (set.includes(((MailboxMessage)it.next()).getUid())) continue;
            it.remove();
        }
        Collections.sort(results);
        if (max > 0 && results.size() > max) {
            results = results.subList(0, max);
        }
        return results.iterator();
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) throws MailboxException {
        ArrayList<MessageUid> results = new ArrayList<MessageUid>();
        for (MailboxMessage member : this.getMembershipByUidForMailbox(mailbox).values()) {
            if (!member.isRecent()) continue;
            results.add(member.getUid());
        }
        Collections.sort(results);
        return results;
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) throws MailboxException {
        ArrayList<MailboxMessage> memberships = new ArrayList<MailboxMessage>(this.getMembershipByUidForMailbox(mailbox).values());
        Collections.sort(memberships);
        for (MailboxMessage m : memberships) {
            if (m.isSeen()) continue;
            return m.getUid();
        }
        return null;
    }

    public Map<MessageUid, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox mailbox, MessageRange set) throws MailboxException {
        HashMap<MessageUid, MessageMetaData> filteredResult = new HashMap<MessageUid, MessageMetaData>();
        Iterator<MailboxMessage> it = this.findInMailbox(mailbox, set, MessageMapper.FetchType.Metadata, -1);
        while (it.hasNext()) {
            MailboxMessage member = it.next();
            if (!member.isDeleted()) continue;
            filteredResult.put(member.getUid(), (MessageMetaData)new SimpleMessageMetaData(member));
            this.delete(mailbox, member);
        }
        return filteredResult;
    }

    public Flags getApplicableFlag(Mailbox mailbox) throws MailboxException {
        return new ApplicableFlagCalculator(this.getMembershipByUidForId((InMemoryId)mailbox.getMailboxId()).values()).computeApplicableFlags();
    }

    public void deleteAll() {
        this.mailboxByUid.clear();
    }

    public void endRequest() {
    }

    protected MessageMetaData copy(Mailbox mailbox, MessageUid uid, long modSeq, MailboxMessage original) throws MailboxException {
        SimpleMailboxMessage message = SimpleMailboxMessage.copy((MailboxId)mailbox.getMailboxId(), (MailboxMessage)original);
        message.setUid(uid);
        message.setModSeq(modSeq);
        Flags flags = original.createFlags();
        flags.add(Flags.Flag.RECENT);
        message.setFlags(flags);
        return this.save(mailbox, (MailboxMessage)message);
    }

    protected MessageMetaData save(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        SimpleMailboxMessage copy = SimpleMailboxMessage.copy((MailboxId)mailbox.getMailboxId(), (MailboxMessage)message);
        copy.setUid(message.getUid());
        copy.setModSeq(message.getModSeq());
        this.getMembershipByUidForMailbox(mailbox).put(message.getUid(), (MailboxMessage)copy);
        return new SimpleMessageMetaData(message);
    }

    protected void begin() throws MailboxException {
    }

    protected void commit() throws MailboxException {
    }

    protected void rollback() throws MailboxException {
    }
}

