/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;
import org.apache.james.mailbox.store.transaction.Mapper;

public class InMemoryMailboxMapper
implements MailboxMapper {
    private static final int INITIAL_SIZE = 128;
    private final ConcurrentHashMap<MailboxPath, Mailbox> mailboxesByPath;
    private final AtomicLong mailboxIdGenerator = new AtomicLong();

    public InMemoryMailboxMapper() {
        this.mailboxesByPath = new ConcurrentHashMap(128);
    }

    public void delete(Mailbox mailbox) throws MailboxException {
        this.mailboxesByPath.remove(mailbox.generateAssociatedPath());
    }

    public void deleteAll() throws MailboxException {
        this.mailboxesByPath.clear();
    }

    public synchronized Mailbox findMailboxByPath(MailboxPath path) throws MailboxException {
        Mailbox result = this.mailboxesByPath.get(path);
        if (result == null) {
            throw new MailboxNotFoundException(path);
        }
        return new SimpleMailbox(result);
    }

    public synchronized Mailbox findMailboxById(MailboxId id) throws MailboxException {
        InMemoryId mailboxId = (InMemoryId)id;
        for (Mailbox mailbox : this.mailboxesByPath.values()) {
            if (!mailbox.getMailboxId().equals(mailboxId)) continue;
            return new SimpleMailbox(mailbox);
        }
        throw new MailboxNotFoundException(mailboxId.serialize());
    }

    public List<Mailbox> findMailboxWithPathLike(MailboxPath path) throws MailboxException {
        String regex = path.getName().replace("%", ".*");
        ArrayList<Mailbox> results = new ArrayList<Mailbox>();
        for (Mailbox mailbox : this.mailboxesByPath.values()) {
            if (!this.mailboxMatchesRegex(mailbox, path, regex)) continue;
            results.add((Mailbox)new SimpleMailbox(mailbox));
        }
        return results;
    }

    private boolean mailboxMatchesRegex(Mailbox mailbox, MailboxPath path, String regex) {
        return Objects.equal((Object)mailbox.getNamespace(), (Object)path.getNamespace()) && Objects.equal((Object)mailbox.getUser(), (Object)path.getUser()) && mailbox.getName().matches(regex);
    }

    public MailboxId save(Mailbox mailbox) throws MailboxException {
        InMemoryId id = (InMemoryId)mailbox.getMailboxId();
        if (id == null) {
            id = InMemoryId.of(this.mailboxIdGenerator.incrementAndGet());
            ((SimpleMailbox)mailbox).setMailboxId((MailboxId)id);
        } else {
            try {
                Mailbox mailboxWithPreviousName = this.findMailboxById(id);
                this.mailboxesByPath.remove(mailboxWithPreviousName.generateAssociatedPath());
            }
            catch (MailboxNotFoundException mailboxWithPreviousName) {
                // empty catch block
            }
        }
        Mailbox previousMailbox = this.mailboxesByPath.putIfAbsent(mailbox.generateAssociatedPath(), mailbox);
        if (previousMailbox != null) {
            throw new MailboxExistsException(mailbox.getName());
        }
        return mailbox.getMailboxId();
    }

    public void endRequest() {
    }

    public boolean hasChildren(Mailbox mailbox, char delimiter) throws MailboxException {
        String mailboxName = mailbox.getName() + delimiter;
        for (Mailbox box : this.mailboxesByPath.values()) {
            if (!this.belongsToSameUser(mailbox, box) || !box.getName().startsWith(mailboxName)) continue;
            return true;
        }
        return false;
    }

    private boolean belongsToSameUser(Mailbox mailbox, Mailbox otherMailbox) {
        return Objects.equal((Object)mailbox.getNamespace(), (Object)otherMailbox.getNamespace()) && Objects.equal((Object)mailbox.getUser(), (Object)otherMailbox.getUser());
    }

    public List<Mailbox> list() throws MailboxException {
        return new ArrayList<Mailbox>(this.mailboxesByPath.values());
    }

    public <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        return (T)transaction.run();
    }

    public void updateACL(Mailbox mailbox, MailboxACL.MailboxACLCommand mailboxACLCommand) throws MailboxException {
        mailbox.setACL(mailbox.getACL().apply(mailboxACLCommand));
    }
}

