/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Attachment;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.transaction.Mapper;

public class InMemoryAttachmentMapper
implements AttachmentMapper {
    private static final int INITIAL_SIZE = 128;
    private final Map<AttachmentId, Attachment> attachmentsById = new ConcurrentHashMap<AttachmentId, Attachment>(128);

    public Attachment getAttachment(AttachmentId attachmentId) throws AttachmentNotFoundException {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        if (!this.attachmentsById.containsKey(attachmentId)) {
            throw new AttachmentNotFoundException(attachmentId.getId());
        }
        return this.attachmentsById.get(attachmentId);
    }

    public List<Attachment> getAttachments(Collection<AttachmentId> attachmentIds) {
        Preconditions.checkArgument((attachmentIds != null ? 1 : 0) != 0);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AttachmentId attachmentId : attachmentIds) {
            if (!this.attachmentsById.containsKey(attachmentId)) continue;
            builder.add((Object)this.attachmentsById.get(attachmentId));
        }
        return builder.build();
    }

    public void storeAttachment(Attachment attachment) throws MailboxException {
        this.attachmentsById.put(attachment.getAttachmentId(), attachment);
    }

    public void endRequest() {
    }

    public <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        return (T)transaction.run();
    }

    public void storeAttachments(Collection<Attachment> attachments) throws MailboxException {
        for (Attachment attachment : attachments) {
            this.storeAttachment(attachment);
        }
    }
}

