/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.transaction.Mapper;

public class InMemoryAnnotationMapper
implements AnnotationMapper {
    private final Table<InMemoryId, String, String> mailboxesAnnotations;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public InMemoryAnnotationMapper() {
        this.mailboxesAnnotations = HashBasedTable.create();
    }

    public void endRequest() {
    }

    public <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        return (T)transaction.run();
    }

    private Iterable<MailboxAnnotation> retrieveAllAnnotations(InMemoryId mailboxId) {
        this.lock.readLock().lock();
        try {
            Iterable iterable = Iterables.transform(this.mailboxesAnnotations.row((Object)mailboxId).entrySet(), (Function)new Function<Map.Entry<String, String>, MailboxAnnotation>(){

                public MailboxAnnotation apply(Map.Entry<String, String> input) {
                    return MailboxAnnotation.newInstance((MailboxAnnotationKey)new MailboxAnnotationKey(input.getKey()), (String)input.getValue());
                }
            });
            return iterable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxId mailboxId) {
        return ImmutableList.copyOf(this.retrieveAllAnnotations((InMemoryId)mailboxId));
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxId mailboxId, final Set<MailboxAnnotationKey> keys) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.retrieveAllAnnotations((InMemoryId)mailboxId), (Predicate)new Predicate<MailboxAnnotation>(){

            public boolean apply(MailboxAnnotation input) {
                return keys.contains(input.getKey());
            }
        }));
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.retrieveAllAnnotations((InMemoryId)mailboxId), this.getPredicateFilterByAll(keys)));
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.getAnnotationsByKeysWithAllDepth(mailboxId, keys), this.getPredicateFilterByOne(keys)));
    }

    private Predicate<MailboxAnnotation> getPredicateFilterByAll(final Set<MailboxAnnotationKey> keys) {
        return new Predicate<MailboxAnnotation>(){

            public boolean apply(MailboxAnnotation input) {
                return Iterables.tryFind((Iterable)keys, (Predicate)InMemoryAnnotationMapper.this.filterAnnotationsByPrefix(input)).isPresent();
            }
        };
    }

    private Predicate<MailboxAnnotation> getPredicateFilterByOne(final Set<MailboxAnnotationKey> keys) {
        return new Predicate<MailboxAnnotation>(){

            public boolean apply(MailboxAnnotation input) {
                return Iterables.tryFind((Iterable)keys, (Predicate)InMemoryAnnotationMapper.this.filterAnnotationsByParentKey(input.getKey())).isPresent();
            }
        };
    }

    private Predicate<MailboxAnnotationKey> filterAnnotationsByParentKey(final MailboxAnnotationKey input) {
        return new Predicate<MailboxAnnotationKey>(){

            public boolean apply(MailboxAnnotationKey key) {
                return input.countComponents() <= key.countComponents() + 1;
            }
        };
    }

    private Predicate<MailboxAnnotationKey> filterAnnotationsByPrefix(final MailboxAnnotation input) {
        return new Predicate<MailboxAnnotationKey>(){

            public boolean apply(MailboxAnnotationKey key) {
                return key.equals((Object)input.getKey()) || StringUtils.startsWith((String)input.getKey().asString(), (String)(key.asString() + "/"));
            }
        };
    }

    public void insertAnnotation(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        Preconditions.checkArgument((!mailboxAnnotation.isNil() ? 1 : 0) != 0);
        this.lock.writeLock().lock();
        try {
            this.mailboxesAnnotations.put((Object)((InMemoryId)mailboxId), (Object)mailboxAnnotation.getKey().asString(), mailboxAnnotation.getValue().get());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void deleteAnnotation(MailboxId mailboxId, MailboxAnnotationKey key) {
        this.lock.writeLock().lock();
        try {
            this.mailboxesAnnotations.remove((Object)mailboxId, (Object)key.asString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean exist(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return this.mailboxesAnnotations.contains((Object)((InMemoryId)mailboxId), (Object)mailboxAnnotation.getKey().asString());
    }

    public int countAnnotations(MailboxId mailboxId) {
        return this.mailboxesAnnotations.row((Object)((InMemoryId)mailboxId)).size();
    }
}

