/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.FetchGroupImpl;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MailboxQuery;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;

public class InMemoryMessageIdManager
implements MessageIdManager {
    private final MailboxManager mailboxManager;

    @Inject
    public InMemoryMessageIdManager(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public void setFlags(Flags newState, MessageManager.FlagsUpdateMode flagsUpdateMode, MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        for (MailboxId mailboxId : mailboxIds) {
            Optional<MessageResult> message = this.findMessageWithId(mailboxId, messageId, FetchGroupImpl.MINIMAL, mailboxSession);
            if (!message.isPresent()) continue;
            this.mailboxManager.getMailbox(mailboxId, mailboxSession).setFlags(newState, flagsUpdateMode, ((MessageResult)message.get()).getUid().toRange(), mailboxSession);
        }
    }

    public List<MessageResult> getMessages(List<MessageId> messages, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<MailboxId> userMailboxIds = this.getUsersMailboxIds(mailboxSession);
        for (MailboxId mailboxId : userMailboxIds) {
            builder.addAll(this.retrieveMailboxMessages(mailboxId, messages, fetchGroup, mailboxSession));
        }
        return builder.build();
    }

    public void delete(MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        for (MailboxId mailboxId : mailboxIds) {
            Optional<MessageResult> maybeMessage = this.findMessageWithId(mailboxId, messageId, FetchGroupImpl.MINIMAL, mailboxSession);
            if (!maybeMessage.isPresent()) continue;
            MessageRange range = ((MessageResult)maybeMessage.get()).getUid().toRange();
            MessageManager messageManager = this.mailboxManager.getMailbox(mailboxId, mailboxSession);
            messageManager.setFlags(new Flags(Flags.Flag.DELETED), MessageManager.FlagsUpdateMode.ADD, range, mailboxSession);
            messageManager.expunge(range, mailboxSession);
        }
    }

    public void setInMailboxes(MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        List<MessageResult> messages = this.getMessages((List<MessageId>)ImmutableList.of((Object)messageId), FetchGroupImpl.MINIMAL, mailboxSession);
        this.filterOnMailboxSession(mailboxIds, mailboxSession);
        if (!messages.isEmpty()) {
            ImmutableSet currentMailboxes = this.currentMailboxes(messages).toSet();
            HashSet targetMailboxes = Sets.newHashSet(mailboxIds);
            ImmutableList mailboxesToRemove = ImmutableList.copyOf((Collection)Sets.difference((Set)currentMailboxes, (Set)targetMailboxes));
            Sets.SetView mailboxesToAdd = Sets.difference((Set)targetMailboxes, (Set)currentMailboxes);
            MessageResult referenceMessage = (MessageResult)Iterables.getLast(messages);
            for (MailboxId mailboxId : mailboxesToAdd) {
                MessageRange messageRange = referenceMessage.getUid().toRange();
                this.mailboxManager.copyMessages(messageRange, referenceMessage.getMailboxId(), mailboxId, mailboxSession);
                this.mailboxManager.getMailbox(mailboxId, mailboxSession).setFlags(referenceMessage.getFlags(), MessageManager.FlagsUpdateMode.REPLACE, messageRange, mailboxSession);
            }
            for (MessageResult message : messages) {
                this.delete(message.getMessageId(), (List<MailboxId>)mailboxesToRemove, mailboxSession);
            }
        }
    }

    private List<MailboxId> getUsersMailboxIds(MailboxSession mailboxSession) throws MailboxException {
        return FluentIterable.from((Iterable)this.mailboxManager.search(this.userMailboxes(mailboxSession), mailboxSession)).transform(this.getMailboxIdFromMetadata()).toList();
    }

    private Function<MailboxMetaData, MailboxId> getMailboxIdFromMetadata() {
        return new Function<MailboxMetaData, MailboxId>(){

            public MailboxId apply(MailboxMetaData input) {
                return input.getId();
            }
        };
    }

    private MailboxQuery userMailboxes(MailboxSession mailboxSession) {
        return MailboxQuery.builder().matchesAll().username(mailboxSession.getUser().getUserName()).build();
    }

    private List<MessageResult> retrieveMailboxMessages(MailboxId mailboxId, List<MessageId> messages, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MessageId messageId : messages) {
            Optional<MessageResult> maybeMessage = this.findMessageWithId(mailboxId, messageId, fetchGroup, mailboxSession);
            if (!maybeMessage.isPresent()) continue;
            builder.add(maybeMessage.get());
        }
        return builder.build();
    }

    private void filterOnMailboxSession(List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxNotFoundException {
        boolean isForbidden = FluentIterable.from(mailboxIds).firstMatch(this.findMailboxBelongsToAnotherSession(mailboxSession)).isPresent();
        if (isForbidden) {
            throw new MailboxNotFoundException("Mailbox does not belong to session");
        }
    }

    private Predicate<MailboxId> findMailboxBelongsToAnotherSession(final MailboxSession mailboxSession) {
        return new Predicate<MailboxId>(){

            public boolean apply(MailboxId input) {
                try {
                    MailboxPath currentMailbox = InMemoryMessageIdManager.this.mailboxManager.getMailbox(input, mailboxSession).getMailboxPath();
                    return !mailboxSession.getUser().isSameUser(currentMailbox.getUser());
                }
                catch (MailboxException e) {
                    return true;
                }
            }
        };
    }

    private FluentIterable<MailboxId> currentMailboxes(List<MessageResult> messages) {
        return FluentIterable.from(messages).transform((Function)new Function<MessageResult, MailboxId>(){

            public MailboxId apply(MessageResult message) {
                return message.getMailboxId();
            }
        });
    }

    private Optional<MessageResult> findMessageWithId(MailboxId mailboxId, MessageId messageId, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        return FluentIterable.from(this.retrieveAllMessages(mailboxId, fetchGroup, mailboxSession)).filter(this.filterByMessageId(messageId)).first();
    }

    private Predicate<MessageResult> filterByMessageId(final MessageId messageId) {
        return new Predicate<MessageResult>(){

            public boolean apply(MessageResult messageResult) {
                return messageResult.getMessageId().equals(messageId);
            }
        };
    }

    private ImmutableList<MessageResult> retrieveAllMessages(MailboxId mailboxId, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        MessageManager messageManager = this.mailboxManager.getMailbox(mailboxId, mailboxSession);
        return ImmutableList.copyOf((Iterator)messageManager.getMessages(MessageRange.all(), fetchGroup, mailboxSession));
    }
}

