/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.inmemory.mail.InMemoryAnnotationMapper;
import org.apache.james.mailbox.inmemory.mail.InMemoryAttachmentMapper;
import org.apache.james.mailbox.inmemory.mail.InMemoryMailboxMapper;
import org.apache.james.mailbox.inmemory.mail.InMemoryMessageMapper;
import org.apache.james.mailbox.inmemory.mail.InMemoryModSeqProvider;
import org.apache.james.mailbox.inmemory.mail.InMemoryUidProvider;
import org.apache.james.mailbox.inmemory.user.InMemorySubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class InMemoryMailboxSessionMapperFactory
extends MailboxSessionMapperFactory {
    private final MailboxMapper mailboxMapper = new InMemoryMailboxMapper();
    private final MessageMapper messageMapper;
    private final SubscriptionMapper subscriptionMapper;
    private final AttachmentMapper attachmentMapper;
    private final AnnotationMapper annotationMapper;
    private final InMemoryUidProvider uidProvider = new InMemoryUidProvider();
    private final InMemoryModSeqProvider modSeqProvider = new InMemoryModSeqProvider();

    public InMemoryMailboxSessionMapperFactory() {
        this.messageMapper = new InMemoryMessageMapper(null, this.uidProvider, this.modSeqProvider);
        this.subscriptionMapper = new InMemorySubscriptionMapper();
        this.attachmentMapper = new InMemoryAttachmentMapper();
        this.annotationMapper = new InMemoryAnnotationMapper();
    }

    public MailboxMapper createMailboxMapper(MailboxSession session) throws MailboxException {
        return this.mailboxMapper;
    }

    public MessageMapper createMessageMapper(MailboxSession session) throws MailboxException {
        return this.messageMapper;
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession session) {
        return null;
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) throws SubscriptionException {
        return this.subscriptionMapper;
    }

    public AttachmentMapper createAttachmentMapper(MailboxSession session) throws MailboxException {
        return this.attachmentMapper;
    }

    public void deleteAll() throws MailboxException {
        ((InMemoryMailboxMapper)this.mailboxMapper).deleteAll();
        ((InMemoryMessageMapper)this.messageMapper).deleteAll();
        ((InMemorySubscriptionMapper)this.subscriptionMapper).deleteAll();
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession session) throws MailboxException {
        return this.annotationMapper;
    }

    public UidProvider getUidProvider() {
        return this.uidProvider;
    }

    public ModSeqProvider getModSeqProvider() {
        return this.modSeqProvider;
    }
}

