/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.query;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import org.apache.james.mailbox.model.SearchQuery;

public class DateResolutionFormater {
    public static DateTimeFormatter DATE_TIME_FOMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");

    public static ZonedDateTime computeUpperDate(ZonedDateTime date, SearchQuery.DateResolution resolution) {
        return DateResolutionFormater.computeLowerDate(date, resolution).plus(1L, DateResolutionFormater.convertDateResolutionField(resolution));
    }

    public static ZonedDateTime computeLowerDate(ZonedDateTime date, SearchQuery.DateResolution resolution) {
        switch (resolution) {
            case Year: {
                return date.truncatedTo(ChronoUnit.DAYS).withDayOfYear(1);
            }
            case Month: {
                return date.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
            }
        }
        return date.truncatedTo(DateResolutionFormater.convertDateResolutionField(resolution));
    }

    private static TemporalUnit convertDateResolutionField(SearchQuery.DateResolution resolution) {
        switch (resolution) {
            case Year: {
                return ChronoUnit.YEARS;
            }
            case Month: {
                return ChronoUnit.MONTHS;
            }
            case Day: {
                return ChronoUnit.DAYS;
            }
            case Hour: {
                return ChronoUnit.HOURS;
            }
            case Minute: {
                return ChronoUnit.MINUTES;
            }
            case Second: {
                return ChronoUnit.SECONDS;
            }
        }
        throw new RuntimeException("Unknown Date resolution used");
    }

    public static ZonedDateTime convertDateToZonedDateTime(Date date) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
    }
}

