/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import java.io.InputStream;
import org.apache.james.mailbox.elasticsearch.json.MimePart;
import org.apache.james.mailbox.elasticsearch.json.MimePartContainerBuilder;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mime4j.stream.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootMimePartContainerBuilder
implements MimePartContainerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootMimePartContainerBuilder.class);
    private MimePart rootMimePart;

    @Override
    public MimePart build() {
        return this.rootMimePart;
    }

    @Override
    public MimePartContainerBuilder using(TextExtractor textExtractor) {
        return this;
    }

    @Override
    public MimePartContainerBuilder addToHeaders(Field field) {
        LOGGER.warn("Trying to add headers to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addBodyContent(InputStream bodyContent) {
        LOGGER.warn("Trying to add body content to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addChild(MimePart mimePart) {
        if (this.rootMimePart == null) {
            this.rootMimePart = mimePart;
        } else {
            LOGGER.warn("Trying to add several children to the Root MimePart container");
        }
        return this;
    }

    @Override
    public MimePartContainerBuilder addFileName(String fileName) {
        LOGGER.warn("Trying to add fineName to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addMediaType(String mediaType) {
        LOGGER.warn("Trying to add media type to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addSubType(String subType) {
        LOGGER.warn("Trying to add sub type to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addContentDisposition(String contentDisposition) {
        LOGGER.warn("Trying to add content disposition to the Root MimePart container");
        return this;
    }
}

