/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.elasticsearch.IndexAttachments;
import org.apache.james.mailbox.elasticsearch.json.EMailers;
import org.apache.james.mailbox.elasticsearch.json.HeaderCollection;
import org.apache.james.mailbox.elasticsearch.json.MimePart;
import org.apache.james.mailbox.elasticsearch.json.MimePartParser;
import org.apache.james.mailbox.elasticsearch.json.Subjects;
import org.apache.james.mailbox.elasticsearch.query.DateResolutionFormater;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.SimpleProperty;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.james.mime4j.MimeException;

public class IndexableMessage {
    public static final SimpleProperty HAS_ATTACHMENT_PROPERTY = new SimpleProperty("JAMES_INTERNALS", "HAS_ATTACHMENT", "true");
    private final List<MimePart> attachments;
    private final EMailers bcc;
    private final Optional<String> bodyHtml;
    private final Optional<String> bodyText;
    private final EMailers cc;
    private final String date;
    private final EMailers from;
    private final boolean hasAttachment;
    private final Multimap<String, String> headers;
    private final boolean isAnswered;
    private final boolean isDeleted;
    private final boolean isDraft;
    private final boolean isFlagged;
    private final boolean isRecent;
    private final boolean isUnRead;
    private final String mailboxId;
    private final String mediaType;
    private final String messageId;
    private final long modSeq;
    private final List<Property> properties;
    private final EMailers replyTo;
    private final String sentDate;
    private final long size;
    private final Subjects subjects;
    private final String subType;
    private final String text;
    private final EMailers to;
    private final long uid;
    private final String[] userFlags;
    private final List<String> users;

    public static Builder builder() {
        return new Builder();
    }

    private IndexableMessage(List<MimePart> attachments, EMailers bcc, Optional<String> bodyHtml, Optional<String> bodyText, EMailers cc, String date, EMailers from, boolean hasAttachment, Multimap<String, String> headers, boolean isAnswered, boolean isDeleted, boolean isDraft, boolean isFlagged, boolean isRecent, boolean isUnRead, String mailboxId, String mediaType, String messageId, long modSeq, List<Property> properties, EMailers replyTo, String sentDate, long size, Subjects subjects, String subType, String text, EMailers to, long uid, String[] userFlags, List<String> users) {
        this.attachments = attachments;
        this.bcc = bcc;
        this.bodyHtml = bodyHtml;
        this.bodyText = bodyText;
        this.cc = cc;
        this.date = date;
        this.from = from;
        this.hasAttachment = hasAttachment;
        this.headers = headers;
        this.isAnswered = isAnswered;
        this.isDeleted = isDeleted;
        this.isDraft = isDraft;
        this.isFlagged = isFlagged;
        this.isRecent = isRecent;
        this.isUnRead = isUnRead;
        this.mailboxId = mailboxId;
        this.mediaType = mediaType;
        this.messageId = messageId;
        this.modSeq = modSeq;
        this.properties = properties;
        this.replyTo = replyTo;
        this.sentDate = sentDate;
        this.size = size;
        this.subjects = subjects;
        this.subType = subType;
        this.text = text;
        this.to = to;
        this.uid = uid;
        this.userFlags = userFlags;
        this.users = users;
    }

    @JsonProperty(value="attachments")
    public List<MimePart> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="bcc")
    public EMailers getBcc() {
        return this.bcc;
    }

    @JsonProperty(value="htmlBody")
    public Optional<String> getBodyHtml() {
        return this.bodyHtml;
    }

    @JsonProperty(value="textBody")
    public Optional<String> getBodyText() {
        return this.bodyText;
    }

    @JsonProperty(value="cc")
    public EMailers getCc() {
        return this.cc;
    }

    @JsonProperty(value="date")
    public String getDate() {
        return this.date;
    }

    @JsonProperty(value="from")
    public EMailers getFrom() {
        return this.from;
    }

    @JsonProperty(value="hasAttachment")
    public boolean getHasAttachment() {
        return this.hasAttachment;
    }

    @JsonProperty(value="headers")
    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="mailboxId")
    public String getMailboxId() {
        return this.mailboxId;
    }

    @JsonProperty(value="mediaType")
    public String getMediaType() {
        return this.mediaType;
    }

    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    @JsonProperty(value="modSeq")
    public long getModSeq() {
        return this.modSeq;
    }

    @JsonProperty(value="properties")
    public List<Property> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="replyTo")
    public EMailers getReplyTo() {
        return this.replyTo;
    }

    @JsonProperty(value="sentDate")
    public String getSentDate() {
        return this.sentDate;
    }

    @JsonProperty(value="size")
    public long getSize() {
        return this.size;
    }

    @JsonProperty(value="subject")
    public Subjects getSubjects() {
        return this.subjects;
    }

    @JsonProperty(value="subtype")
    public String getSubType() {
        return this.subType;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="to")
    public EMailers getTo() {
        return this.to;
    }

    @JsonProperty(value="uid")
    public Long getUid() {
        return this.uid;
    }

    @JsonProperty(value="userFlags")
    public String[] getUserFlags() {
        return this.userFlags;
    }

    @JsonProperty(value="users")
    public List<String> getUsers() {
        return this.users;
    }

    @JsonProperty(value="isAnswered")
    public boolean isAnswered() {
        return this.isAnswered;
    }

    @JsonProperty(value="isDeleted")
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="isDraft")
    public boolean isDraft() {
        return this.isDraft;
    }

    @JsonProperty(value="isFlagged")
    public boolean isFlagged() {
        return this.isFlagged;
    }

    @JsonProperty(value="isRecent")
    public boolean isRecent() {
        return this.isRecent;
    }

    @JsonProperty(value="isUnread")
    public boolean isUnRead() {
        return this.isUnRead;
    }

    public static class Builder {
        private IndexAttachments indexAttachments;
        private MailboxMessage message;
        private TextExtractor textExtractor;
        private List<MailboxSession.User> users;
        private ZoneId zoneId;

        private static ZonedDateTime getSanitizedInternalDate(MailboxMessage message, ZoneId zoneId) {
            if (message.getInternalDate() == null) {
                return ZonedDateTime.now();
            }
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(message.getInternalDate().getTime()), zoneId);
        }

        private Builder() {
        }

        public IndexableMessage build() {
            Preconditions.checkNotNull((Object)this.message.getMailboxId());
            Preconditions.checkNotNull(this.users);
            Preconditions.checkNotNull((Object)this.textExtractor);
            Preconditions.checkNotNull((Object)((Object)this.indexAttachments));
            Preconditions.checkNotNull((Object)this.zoneId);
            Preconditions.checkState((!this.users.isEmpty() ? 1 : 0) != 0);
            try {
                return this.instanciateIndexedMessage();
            }
            catch (IOException | MimeException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public Builder extractor(TextExtractor textExtractor) {
            this.textExtractor = textExtractor;
            return this;
        }

        public Builder indexAttachments(IndexAttachments indexAttachments) {
            this.indexAttachments = indexAttachments;
            return this;
        }

        public Builder message(MailboxMessage message) {
            this.message = message;
            return this;
        }

        public Builder users(List<MailboxSession.User> users) {
            this.users = users;
            return this;
        }

        public Builder zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        private boolean computeHasAttachment(MailboxMessage message) {
            return message.getProperties().stream().anyMatch(property -> property.equals(HAS_ATTACHMENT_PROPERTY));
        }

        private IndexableMessage instanciateIndexedMessage() throws IOException, MimeException {
            String messageId = SearchUtil.getSerializedMessageIdIfSupportedByUnderlyingStorageOrNull((MailboxMessage)this.message);
            MimePart parsingResult = new MimePartParser((Message)this.message, this.textExtractor).parse();
            List stringifiedUsers = (List)this.users.stream().map(MailboxSession.User::getUserName).collect(Guavate.toImmutableList());
            Optional<String> bodyText = parsingResult.locateFirstTextBody();
            Optional<String> bodyHtml = parsingResult.locateFirstHtmlBody();
            boolean hasAttachment = this.computeHasAttachment(this.message);
            List<MimePart> attachments = this.setFlattenedAttachments(parsingResult, this.indexAttachments);
            HeaderCollection headerCollection = parsingResult.getHeaderCollection();
            ZonedDateTime internalDate = Builder.getSanitizedInternalDate(this.message, this.zoneId);
            Multimap<String, String> headers = headerCollection.getHeaders();
            Subjects subjects = Subjects.from(headerCollection.getSubjectSet());
            EMailers from = EMailers.from(headerCollection.getFromAddressSet());
            EMailers to = EMailers.from(headerCollection.getToAddressSet());
            EMailers replyTo = EMailers.from(headerCollection.getReplyToAddressSet());
            EMailers cc = EMailers.from(headerCollection.getCcAddressSet());
            EMailers bcc = EMailers.from(headerCollection.getBccAddressSet());
            String sentDate = DateResolutionFormater.DATE_TIME_FOMATTER.format(headerCollection.getSentDate().orElse(internalDate));
            String text = Stream.of(from.serialize(), to.serialize(), cc.serialize(), bcc.serialize(), subjects.serialize(), bodyText.orElse(null), bodyHtml.orElse(null)).filter(str -> !Strings.isNullOrEmpty((String)str)).collect(Collectors.joining(" "));
            long uid = this.message.getUid().asLong();
            String mailboxId = this.message.getMailboxId().serialize();
            long modSeq = this.message.getModSeq();
            long size = this.message.getFullContentOctets();
            String date = DateResolutionFormater.DATE_TIME_FOMATTER.format(Builder.getSanitizedInternalDate(this.message, this.zoneId));
            String mediaType = this.message.getMediaType();
            String subType = this.message.getSubType();
            boolean isAnswered = this.message.isAnswered();
            boolean isDeleted = this.message.isDeleted();
            boolean isDraft = this.message.isDraft();
            boolean isFlagged = this.message.isFlagged();
            boolean isRecent = this.message.isRecent();
            boolean isUnRead = !this.message.isSeen();
            String[] userFlags = this.message.createFlags().getUserFlags();
            List properties = this.message.getProperties();
            return new IndexableMessage(attachments, bcc, bodyHtml, bodyText, cc, date, from, hasAttachment, headers, isAnswered, isDeleted, isDraft, isFlagged, isRecent, isUnRead, mailboxId, mediaType, messageId, modSeq, properties, replyTo, sentDate, size, subjects, subType, text, to, uid, userFlags, stringifiedUsers);
        }

        private List<MimePart> setFlattenedAttachments(MimePart parsingResult, IndexAttachments indexAttachments) {
            if (IndexAttachments.YES.equals((Object)indexAttachments)) {
                return (List)parsingResult.getAttachmentsStream().collect(Guavate.toImmutableList());
            }
            return ImmutableList.of();
        }
    }
}

