/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.mailbox.elasticsearch.json.EMailer;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.field.address.LenientAddressParser;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.james.util.date.ImapDateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderCollection {
    public static final String TO = "to";
    public static final String FROM = "from";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    public static final String REPLY_TO = "reply-to";
    public static final String SUBJECT = "subject";
    public static final String DATE = "date";
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderCollection.class);
    private final ImmutableSet<EMailer> toAddressSet;
    private final ImmutableSet<EMailer> fromAddressSet;
    private final ImmutableSet<EMailer> ccAddressSet;
    private final ImmutableSet<EMailer> bccAddressSet;
    private final ImmutableSet<EMailer> replyToAddressSet;
    private final ImmutableSet<String> subjectSet;
    private final ImmutableMultimap<String, String> headers;
    private final Optional<ZonedDateTime> sentDate;

    public static Builder builder() {
        return new Builder();
    }

    private HeaderCollection(ImmutableSet<EMailer> toAddressSet, ImmutableSet<EMailer> fromAddressSet, ImmutableSet<EMailer> ccAddressSet, ImmutableSet<EMailer> bccAddressSet, ImmutableSet<EMailer> replyToAddressSet, ImmutableSet<String> subjectSet, ImmutableMultimap<String, String> headers, Optional<ZonedDateTime> sentDate) {
        this.toAddressSet = toAddressSet;
        this.fromAddressSet = fromAddressSet;
        this.ccAddressSet = ccAddressSet;
        this.bccAddressSet = bccAddressSet;
        this.replyToAddressSet = replyToAddressSet;
        this.subjectSet = subjectSet;
        this.headers = headers;
        this.sentDate = sentDate;
    }

    public Set<EMailer> getToAddressSet() {
        return this.toAddressSet;
    }

    public Set<EMailer> getFromAddressSet() {
        return this.fromAddressSet;
    }

    public Set<EMailer> getCcAddressSet() {
        return this.ccAddressSet;
    }

    public Set<EMailer> getBccAddressSet() {
        return this.bccAddressSet;
    }

    public Set<EMailer> getReplyToAddressSet() {
        return this.replyToAddressSet;
    }

    public Set<String> getSubjectSet() {
        return this.subjectSet;
    }

    public Optional<ZonedDateTime> getSentDate() {
        return this.sentDate;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        private static final Pattern DATE_SANITIZING_PATTERN = Pattern.compile(" *\\(.*\\) *");
        private final Set<EMailer> toAddressSet = new HashSet<EMailer>();
        private final Set<EMailer> fromAddressSet = new HashSet<EMailer>();
        private final Set<EMailer> ccAddressSet = new HashSet<EMailer>();
        private final Set<EMailer> bccAddressSet = new HashSet<EMailer>();
        private final Set<EMailer> replyToAddressSet = new HashSet<EMailer>();
        private final Set<String> subjectSet = new HashSet<String>();
        private final Multimap<String, String> headers = ArrayListMultimap.create();
        private Optional<ZonedDateTime> sentDate = Optional.empty();

        private Builder() {
        }

        public Builder add(Field field) {
            Preconditions.checkNotNull((Object)field);
            String headerName = field.getName().toLowerCase(Locale.US);
            String sanitizedValue = MimeUtil.unscrambleHeaderValue((String)field.getBody());
            this.headers.put((Object)headerName, (Object)sanitizedValue);
            this.handleSpecificHeader(headerName, sanitizedValue);
            return this;
        }

        public HeaderCollection build() {
            return new HeaderCollection(ImmutableSet.copyOf(this.toAddressSet), ImmutableSet.copyOf(this.fromAddressSet), ImmutableSet.copyOf(this.ccAddressSet), ImmutableSet.copyOf(this.bccAddressSet), ImmutableSet.copyOf(this.replyToAddressSet), ImmutableSet.copyOf(this.subjectSet), ImmutableMultimap.copyOf(this.headers), this.sentDate);
        }

        private void handleSpecificHeader(String headerName, String headerValue) {
            switch (headerName) {
                case "to": 
                case "from": 
                case "cc": 
                case "bcc": 
                case "reply-to": {
                    this.manageAddressField(headerName, headerValue);
                    break;
                }
                case "subject": {
                    this.subjectSet.add(headerValue);
                    break;
                }
                case "date": {
                    this.sentDate = this.toISODate(headerValue);
                }
            }
        }

        private void manageAddressField(String headerName, String headerValue) {
            LenientAddressParser.DEFAULT.parseAddressList((CharSequence)headerValue).stream().flatMap(this::convertAddressToMailboxStream).map(mailbox -> new EMailer(SearchUtil.getDisplayAddress((Mailbox)mailbox), mailbox.getAddress())).collect(Collectors.toCollection(() -> this.getAddressSet(headerName)));
        }

        private Stream<Mailbox> convertAddressToMailboxStream(Address address) {
            if (address instanceof Mailbox) {
                return Stream.of((Mailbox)address);
            }
            if (address instanceof Group) {
                return ((Group)address).getMailboxes().stream();
            }
            return Stream.empty();
        }

        private Set<EMailer> getAddressSet(String headerName) {
            switch (headerName) {
                case "to": {
                    return this.toAddressSet;
                }
                case "from": {
                    return this.fromAddressSet;
                }
                case "cc": {
                    return this.ccAddressSet;
                }
                case "bcc": {
                    return this.bccAddressSet;
                }
                case "reply-to": {
                    return this.replyToAddressSet;
                }
            }
            throw new RuntimeException(headerName + " is not a address header name");
        }

        private Optional<ZonedDateTime> toISODate(String value) {
            try {
                return Optional.of(ZonedDateTime.parse(this.sanitizeDateStringHeaderValue(value), ImapDateTimeFormatter.rfc5322()));
            }
            catch (Exception e) {
                LOGGER.info("Can not parse receive date " + value);
                return Optional.empty();
            }
        }

        @VisibleForTesting
        String sanitizeDateStringHeaderValue(String value) {
            Matcher sanitizerMatcher = DATE_SANITIZING_PATTERN.matcher(value);
            if (sanitizerMatcher.find()) {
                return value.substring(0, sanitizerMatcher.start());
            }
            return value;
        }
    }
}

