/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.json;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.mailbox.elasticsearch.json.EMailer;
import org.apache.james.mailbox.elasticsearch.json.Serializable;

public class EMailers
implements Serializable {
    private final Set<EMailer> emailers;

    public static EMailers from(Set<EMailer> emailers) {
        Preconditions.checkNotNull(emailers, (Object)"'emailers' is mandatory");
        return new EMailers(emailers);
    }

    private EMailers(Set<EMailer> emailers) {
        this.emailers = emailers;
    }

    @JsonValue
    public Set<EMailer> getEmailers() {
        return this.emailers;
    }

    @Override
    public String serialize() {
        return this.emailers.stream().map(EMailer::serialize).collect(Collectors.joining(" "));
    }
}

