/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.james.backends.es.ElasticSearchIndexer;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.elasticsearch.json.MessageToElasticSearchJson;
import org.apache.james.mailbox.elasticsearch.search.ElasticSearchSearcher;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchListeningMessageSearchIndex
extends ListeningMessageSearchIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchListeningMessageSearchIndex.class);
    private static final String ID_SEPARATOR = ":";
    private final ElasticSearchIndexer indexer;
    private final ElasticSearchSearcher searcher;
    private final MessageToElasticSearchJson messageToElasticSearchJson;

    @Inject
    public ElasticSearchListeningMessageSearchIndex(MessageMapperFactory factory, ElasticSearchIndexer indexer, ElasticSearchSearcher searcher, MessageToElasticSearchJson messageToElasticSearchJson) {
        super(factory);
        this.indexer = indexer;
        this.messageToElasticSearchJson = messageToElasticSearchJson;
        this.searcher = searcher;
    }

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.ONCE;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities() {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, MailboxManager.SearchCapabilities.Text);
    }

    public Iterator<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        MailboxId mailboxId = mailbox.getMailboxId();
        MultimailboxesSearchQuery query = MultimailboxesSearchQuery.from((SearchQuery)searchQuery).inMailboxes(new MailboxId[]{mailboxId}).build();
        Optional<Long> noLimit = Optional.empty();
        return this.searcher.search((List<MailboxSession.User>)ImmutableList.of((Object)session.getUser()), query, noLimit).map(MessageSearchIndex.SearchResult::getMessageUid).iterator();
    }

    public List<MessageId> search(MailboxSession session, MultimailboxesSearchQuery searchQuery, long limit) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        return (List)this.searcher.search((List<MailboxSession.User>)ImmutableList.of((Object)session.getUser()), searchQuery, Optional.empty()).peek(this::logIfNoMessageId).map(MessageSearchIndex.SearchResult::getMessageId).map(com.google.common.base.Optional::get).distinct().limit(limit).collect(Guavate.toImmutableList());
    }

    public void add(MailboxSession session, Mailbox mailbox, MailboxMessage message) throws MailboxException {
        try {
            LOGGER.info("Indexing mailbox {}-{} of user {} on message {}", new Object[]{mailbox.getName(), mailbox.getMailboxId(), session.getUser().getUserName(), message.getUid()});
            this.indexer.indexMessage(this.indexIdFor(mailbox, message.getUid()), this.messageToElasticSearchJson.convertToJson(message, (List<MailboxSession.User>)ImmutableList.of((Object)session.getUser())));
        }
        catch (Exception e) {
            try {
                LOGGER.warn("Indexing mailbox {}-{} of user {} on message {} without attachments ", new Object[]{mailbox.getName(), mailbox.getMailboxId(), session.getUser().getUserName(), message.getUid()});
                this.indexer.indexMessage(this.indexIdFor(mailbox, message.getUid()), this.messageToElasticSearchJson.convertToJsonWithoutAttachment(message, (List<MailboxSession.User>)ImmutableList.of((Object)session.getUser())));
            }
            catch (JsonProcessingException e1) {
                LOGGER.error("Error when indexing mailbox {}-{} of user {} on message {} without its attachment", new Object[]{mailbox.getName(), mailbox.getMailboxId(), session.getUser().getUserName(), message.getUid(), e1});
            }
        }
    }

    public void delete(MailboxSession session, Mailbox mailbox, List<MessageUid> expungedUids) throws MailboxException {
        try {
            this.indexer.deleteMessages(expungedUids.stream().map(uid -> this.indexIdFor(mailbox, (MessageUid)uid)).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOGGER.error("Error when deleting messages {} in mailbox {} from index", new Object[]{mailbox.getMailboxId().serialize(), expungedUids, e});
        }
    }

    public void deleteAll(MailboxSession session, Mailbox mailbox) throws MailboxException {
        try {
            this.indexer.deleteAllMatchingQuery((QueryBuilder)QueryBuilders.termQuery((String)"mailboxId", (String)mailbox.getMailboxId().serialize()));
        }
        catch (Exception e) {
            LOGGER.error("Error when deleting all messages in mailbox {}", (Object)mailbox.getMailboxId().serialize(), (Object)e);
        }
    }

    public void update(MailboxSession session, Mailbox mailbox, List<UpdatedFlags> updatedFlagsList) throws MailboxException {
        try {
            this.indexer.updateMessages(updatedFlagsList.stream().map(updatedFlags -> this.createUpdatedDocumentPartFromUpdatedFlags(mailbox, (UpdatedFlags)updatedFlags)).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOGGER.error("Error when updating index on mailbox {}", (Object)mailbox.getMailboxId().serialize(), (Object)e);
        }
    }

    private ElasticSearchIndexer.UpdatedRepresentation createUpdatedDocumentPartFromUpdatedFlags(Mailbox mailbox, UpdatedFlags updatedFlags) {
        try {
            return new ElasticSearchIndexer.UpdatedRepresentation(this.indexIdFor(mailbox, updatedFlags.getUid()), this.messageToElasticSearchJson.getUpdatedJsonMessagePart(updatedFlags.getNewFlags(), updatedFlags.getModSeq()));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error while creating updatedDocumentParts", e);
        }
    }

    private String indexIdFor(Mailbox mailbox, MessageUid uid) {
        return String.join((CharSequence)ID_SEPARATOR, mailbox.getMailboxId().serialize(), String.valueOf(uid.asLong()));
    }

    private void logIfNoMessageId(MessageSearchIndex.SearchResult searchResult) {
        if (!searchResult.getMessageId().isPresent()) {
            LOGGER.error("No messageUid for {} in mailbox {}", (Object)searchResult.getMessageUid(), (Object)searchResult.getMailboxId());
        }
    }
}

