/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.processor.CamelLogProcessor;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CamelLogger
extends ServiceSupport
implements AsyncProcessor {
    private Logger log;
    private LoggingLevel level;
    private ExchangeFormatter formatter = new CamelLogProcessor.ToStringExchangeFormatter();

    public CamelLogger() {
        this(LoggerFactory.getLogger(CamelLogger.class));
    }

    public CamelLogger(Logger log) {
        this(log, LoggingLevel.INFO);
    }

    public CamelLogger(Logger log, LoggingLevel level) {
        this.log = log;
        this.level = level;
    }

    public CamelLogger(String logName) {
        this(LoggerFactory.getLogger((String)logName));
    }

    public CamelLogger(String logName, LoggingLevel level) {
        this(LoggerFactory.getLogger((String)logName), level);
    }

    public CamelLogger(Logger log, ExchangeFormatter formatter) {
        this(log);
        this.formatter = formatter;
    }

    public String toString() {
        return "Logger[" + this.log + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(this.logMessage(exchange));
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(this.logMessage(exchange));
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(this.logMessage(exchange));
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(this.logMessage(exchange));
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(this.logMessage(exchange));
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + this.logMessage(exchange));
            }
        }
        callback.done(true);
        return true;
    }

    public void process(Exchange exchange, Throwable exception) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(this.logMessage(exchange), exception);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(this.logMessage(exchange), exception);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(this.logMessage(exchange), exception);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(this.logMessage(exchange), exception);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(this.logMessage(exchange), exception);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + this.logMessage(exchange));
            }
        }
    }

    public void process(Exchange exchange, String message) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(this.logMessage(exchange, message));
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(this.logMessage(exchange, message));
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(this.logMessage(exchange, message));
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(this.logMessage(exchange, message));
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(this.logMessage(exchange, message));
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + this.logMessage(exchange, message));
            }
        }
    }

    public void log(String message, LoggingLevel loggingLevel) {
        LoggingLevel oldLogLevel = this.getLevel();
        this.setLevel(loggingLevel);
        this.log(message);
        this.setLevel(oldLogLevel);
    }

    public void log(String message) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(message);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(message);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(message);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(message);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(message);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + message);
            }
        }
    }

    public void log(String message, Throwable exception, LoggingLevel loggingLevel) {
        LoggingLevel oldLogLevel = this.getLevel();
        this.setLevel(loggingLevel);
        this.log(message, exception);
        this.setLevel(oldLogLevel);
    }

    public void log(String message, Throwable exception) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(message, exception);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(message, exception);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(message, exception);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(message, exception);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(message, exception);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + message, exception);
            }
        }
    }

    protected String logMessage(Exchange exchange) {
        return this.formatter.format(exchange);
    }

    protected String logMessage(Exchange exchange, String message) {
        return this.formatter.format(exchange) + message;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        this.level = level;
    }

    public void setFormatter(ExchangeFormatter formatter) {
        this.formatter = formatter;
    }

    public void setLogName(String logName) {
        this.log = LoggerFactory.getLogger((String)logName);
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

