/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.indexer.registrations;

import com.google.common.base.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.model.MailboxPath;

public class GlobalRegistration
implements MailboxListener {
    private final ConcurrentHashMap<MailboxPath, Boolean> isPathDeleted = new ConcurrentHashMap();
    private final ConcurrentHashMap<MailboxPath, MailboxPath> nameCorrespondence = new ConcurrentHashMap();

    public Optional<MailboxPath> getPathToIndex(MailboxPath mailboxPath) {
        if (this.isPathDeleted.get(mailboxPath) != null) {
            return Optional.absent();
        }
        return Optional.of((Object)Optional.fromNullable((Object)this.nameCorrespondence.get(mailboxPath)).or((Object)mailboxPath));
    }

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.EACH_NODE;
    }

    public MailboxListener.ExecutionMode getExecutionMode() {
        return MailboxListener.ExecutionMode.SYNCHRONOUS;
    }

    public void event(MailboxListener.Event event) {
        if (event instanceof MailboxListener.MailboxDeletion) {
            this.isPathDeleted.put(event.getMailboxPath(), true);
        } else if (event instanceof MailboxListener.MailboxRenamed) {
            this.nameCorrespondence.put(event.getMailboxPath(), ((MailboxListener.MailboxRenamed)event).getNewPath());
        }
    }
}

