/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.indexer.events;

import com.google.common.base.Objects;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.events.ImpactingEventType;
import org.apache.james.mailbox.indexer.events.ImpactingMessageEvent;
import org.apache.james.mailbox.model.MailboxPath;

public class MessageDeletedEvent
implements ImpactingMessageEvent {
    private final MailboxPath mailboxPath;
    private final MessageUid uid;

    public MessageDeletedEvent(MailboxPath mailboxPath, MessageUid uid) {
        this.mailboxPath = mailboxPath;
        this.uid = uid;
    }

    @Override
    public MessageUid getUid() {
        return this.uid;
    }

    @Override
    public MailboxPath getMailboxPath() {
        return this.mailboxPath;
    }

    @Override
    public ImpactingEventType getType() {
        return ImpactingEventType.Deletion;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageDeletedEvent that = (MessageDeletedEvent)o;
        return Objects.equal((Object)this.uid, (Object)that.uid) && Objects.equal((Object)this.mailboxPath, (Object)that.mailboxPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uid, this.mailboxPath});
    }
}

