/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.indexer.events;

import com.google.common.base.Objects;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.events.ImpactingEventType;
import org.apache.james.mailbox.indexer.events.ImpactingMessageEvent;
import org.apache.james.mailbox.model.MailboxPath;

public class FlagsMessageEvent
implements ImpactingMessageEvent {
    private final MailboxPath mailboxPath;
    private final MessageUid uid;
    private final Flags flags;

    public FlagsMessageEvent(MailboxPath mailboxPath, MessageUid uid, Flags flags) {
        this.mailboxPath = mailboxPath;
        this.uid = uid;
        this.flags = flags;
    }

    @Override
    public MessageUid getUid() {
        return this.uid;
    }

    @Override
    public MailboxPath getMailboxPath() {
        return this.mailboxPath;
    }

    @Override
    public ImpactingEventType getType() {
        return ImpactingEventType.FlagsUpdate;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagsMessageEvent that = (FlagsMessageEvent)o;
        return Objects.equal((Object)this.uid, (Object)that.uid) && Objects.equal((Object)this.mailboxPath, (Object)that.mailboxPath) && Objects.equal((Object)this.flags, (Object)that.flags);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uid, this.mailboxPath, this.flags});
    }
}

