/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.copier;

import java.io.IOException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.copier.MailboxCopier;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.store.streaming.InputStreamContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxCopierImpl
implements MailboxCopier {
    private static final MessageResult.FetchGroup GROUP = new MessageResult.FetchGroup(){

        public int content() {
            return 512;
        }

        public Set<MessageResult.FetchGroup.PartContentDescriptor> getPartContentDescriptors() {
            return new HashSet<MessageResult.FetchGroup.PartContentDescriptor>();
        }
    };
    private Logger log = LoggerFactory.getLogger((String)MailboxCopierImpl.class.getName());

    @Override
    public void copyMailboxes(MailboxManager srcMailboxManager, MailboxManager dstMailboxManager) throws MailboxException, IOException {
        Calendar start = Calendar.getInstance();
        List mailboxPathList = null;
        MailboxSession srcMailboxSession = srcMailboxManager.createSystemSession("manager", this.log);
        srcMailboxManager.startProcessingRequest(srcMailboxSession);
        mailboxPathList = srcMailboxManager.list(srcMailboxSession);
        srcMailboxManager.endProcessingRequest(srcMailboxSession);
        this.log.info("Found " + mailboxPathList.size() + " mailboxes in source mailbox manager.");
        for (int i = 0; i < mailboxPathList.size(); ++i) {
            this.log.info("Mailbox#" + i + " path=" + mailboxPathList.get(i));
        }
        MailboxPath mailboxPath = null;
        for (int i = 0; i < mailboxPathList.size(); ++i) {
            mailboxPath = (MailboxPath)mailboxPathList.get(i);
            if (mailboxPath.getName() != null && mailboxPath.getName().trim().length() > 0) {
                this.log.info("Ready to copy source mailbox path=" + mailboxPath.toString());
                srcMailboxSession = srcMailboxManager.createSystemSession(mailboxPath.getUser(), this.log);
                MailboxSession dstMailboxSession = dstMailboxManager.createSystemSession(mailboxPath.getUser(), this.log);
                dstMailboxManager.startProcessingRequest(dstMailboxSession);
                try {
                    dstMailboxManager.createMailbox(mailboxPath, dstMailboxSession);
                    this.log.info("Destination mailbox " + i + "/" + mailboxPathList.size() + " created with path=" + mailboxPath.toString() + " after " + (Calendar.getInstance().getTimeInMillis() - start.getTimeInMillis()) + " ms.");
                }
                catch (MailboxExistsException e) {
                    this.log.error("Mailbox " + i + " with path=" + mailboxPath.toString() + " already exists.", (Throwable)e);
                }
                dstMailboxManager.endProcessingRequest(dstMailboxSession);
                srcMailboxManager.startProcessingRequest(srcMailboxSession);
                MessageManager srcMessageManager = srcMailboxManager.getMailbox(mailboxPath, srcMailboxSession);
                srcMailboxManager.endProcessingRequest(srcMailboxSession);
                dstMailboxManager.startProcessingRequest(dstMailboxSession);
                MessageManager dstMessageManager = dstMailboxManager.getMailbox(mailboxPath, dstMailboxSession);
                int j = 0;
                MessageResultIterator messageResultIterator = srcMessageManager.getMessages(MessageRange.all(), GROUP, srcMailboxSession);
                while (messageResultIterator.hasNext()) {
                    MessageResult messageResult = (MessageResult)messageResultIterator.next();
                    InputStreamContent content = (InputStreamContent)messageResult.getFullContent();
                    dstMailboxManager.startProcessingRequest(dstMailboxSession);
                    dstMessageManager.appendMessage(content.getInputStream(), messageResult.getInternalDate(), dstMailboxSession, messageResult.getFlags().contains(Flags.Flag.RECENT), messageResult.getFlags());
                    dstMailboxManager.endProcessingRequest(dstMailboxSession);
                    this.log.info("MailboxMessage #" + j + " appended in destination mailbox with path=" + mailboxPath.toString());
                    ++j;
                }
                dstMailboxManager.endProcessingRequest(dstMailboxSession);
                continue;
            }
            this.log.info("Destination mailbox " + i + "/" + mailboxPathList.size() + " with path=" + mailboxPath.toString() + " has a null or empty name");
        }
        this.log.info("Mailboxes copied in " + (Calendar.getInstance().getTimeInMillis() - start.getTimeInMillis()) + " ms.");
    }

    public void setLog(Logger log) {
        this.log = log;
    }
}

